/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "nickcombo.h"
#include <qsettings.h>

const QString NickCombo::key = "/history/nicks";

NickCombo::NickCombo(QWidget *parent, int max): QComboBox(true, parent)/*{{{*/
{
	setMaxCount(max);
	setDuplicatesEnabled(false);
	setInsertionPolicy(QComboBox::AtTop);
}/*}}}*/

NickCombo::~NickCombo()/*{{{*/
{
}/*}}}*/

QStringList NickCombo::getAll() const/*{{{*/
{
	QStringList l;
	const int c = count();
	for (int i=0; i<c; i++)
		l.append(text(i));
	return l;
}/*}}}*/

bool NickCombo::save(QSettings *cfg)/*{{{*/
{
	Q_ASSERT(cfg);

	cfg->writeEntry(key, getAll());
}/*}}}*/

bool NickCombo::load(QSettings *cfg)/*{{{*/
{
	Q_ASSERT(cfg);

	QStringList l = cfg->readListEntry(key);
	insertStringList(l);

	return true;
}/*}}}*/

bool NickCombo::exists(const QString &nick)/*{{{*/
{
	const int c = count();
	for (int i=0; i<c; i++)
		if (text(i) == nick)
			return true;
	return false;
}/*}}}*/

