/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __MSGRCVWIN_H
#define __MSGRCVWIN_H

#include <qwidget.h>

class QTextEdit;
class QPushButton;

class MessageRcvWindow: public QWidget
{
	Q_OBJECT
		
	private slots:
		void replyPressed();
		void chatPressed();
		
	signals:
		void reply(const QString &nick, const QString &str);
		void chat(const QString &nick);
		
	private:
		QString from;
		QTextEdit *msg, *rpl;
		QPushButton *b_ok, *b_reply, *b_chat;

	public:
		MessageRcvWindow(const QString &from, const QString &msg);
		virtual ~MessageRcvWindow();
};

#endif

