/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include <qglobal.h>
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include "icons.h"
#include "global.h"

QIconSet Icons::icon_comm;
QIconSet Icons::icon_user;
QIconSet Icons::icon_user_dnd;
QIconSet Icons::icon_user_away;
QIconSet Icons::icon_user_offline;
QIconSet Icons::icon_channel;
QIconSet Icons::icon_channel_normal;
QIconSet Icons::icon_channel_alert;
QIconSet Icons::icon_private;
QIconSet Icons::icon_private_alert;
QIconSet Icons::icon_info;
QIconSet Icons::icon_message;
QIconSet Icons::icon_massmessage;
QIconSet Icons::icon_enter;
QIconSet Icons::icon_settings;
QIconSet Icons::icon_beep;

bool Icons::setTheme(const QString &name)/*{{{*/
{
	ThemesList themes = Icons::getThemes();
	ThemeInfo deftheme;
	for (ThemesList::Iterator it = themes.begin(); it!=themes.end(); ++it)
	{
		if ((*it).getName() == "default")
			deftheme = *it;
		if ((*it).getName() == name)
			return setTheme(*it);
	}
	return setTheme(deftheme);
}/*}}}*/

bool Icons::setTheme(const ThemeInfo &theme)/*{{{*/
{
	QIconSet::setIconSize(QIconSet::Small, QSize(16,16));
	
	QString datapath = theme.getPath() + "/";
	icon_comm = QIconSet(QPixmap(datapath + "comm.png"));
	icon_user = QIconSet(QPixmap(datapath + "user.png"));
	icon_user_dnd = QIconSet(QPixmap(datapath + "user_dnd.png"));
	icon_user_away = QIconSet(QPixmap(datapath + "user_away.png"));
	icon_user_offline = QIconSet(QPixmap(datapath + "user_offline.png"));
	icon_channel = QIconSet(QPixmap(datapath + "channel.png"));
	icon_channel_normal = QIconSet(QPixmap(datapath + "channel_normal.png"));
	icon_channel_alert = QIconSet(QPixmap(datapath + "channel_alert.png"));
	//icon_channeltab.setPixmap((datapath + "channel_normal.png"), QIconSet::Large, QIconSet::Normal);
	//icon_channeltab.setPixmap((datapath + "channel_alert.png"), QIconSet::Large, QIconSet::Active);
	icon_private = QIconSet(QPixmap(datapath + "priv.png"));
	icon_private_alert = QIconSet(QPixmap(datapath + "priv_alert.png"));
	icon_info = QIconSet(QPixmap(datapath + "info.png"));
	icon_message = QIconSet(QPixmap(datapath + "message.png"));
	icon_massmessage = QIconSet(QPixmap(datapath + "massmessage.png"));
	icon_enter = QIconSet(QPixmap(datapath + "enter.png"));
	icon_settings = QIconSet(QPixmap(datapath + "settings.png"));
	icon_beep = QIconSet(QPixmap(datapath + "beep.png"));
	
	if (icon_comm.isNull() ||
	    icon_user.isNull() ||
	    icon_user_dnd.isNull() ||
	    icon_user_away.isNull() ||
	    icon_user_offline.isNull() ||
	    icon_channel.isNull() ||
	    icon_private.isNull() ||
	    icon_info.isNull() ||
	    icon_message.isNull() ||
	    icon_enter.isNull() ||
	    icon_settings.isNull())
	{
		qWarning("error: no pixmap found in %s. Did you install vyqchat correctly?", datapath.latin1()); 
		return false;
	}
	return true;
}/*}}}*/

ThemesList Icons::getThemes()/*{{{*/
{
	ThemesList themes;
	const QString paths[2] = { QDir::homeDirPath() + "/.vyqchat/themes", QString(DATADIR) /*+ "/themes"*/ };
	for (int i=0; i<2; i++)
	{
		QDir tdir(paths[i]);
		QStringList dirs1 = tdir.entryList(QDir::Dirs);
		for (QStringList::Iterator it = dirs1.begin(); it != dirs1.end(); ++it)
			if ((*it != ".") && (*it != ".."))
			{
				QFile f(tdir.filePath(*it) + "/themeinfo");
				if (f.exists() && f.open(IO_ReadOnly))
				{
					QTextStream str(&f);
					QString info;
					int lines = 3;
					while ((!str.atEnd()) && lines--) info += str.readLine() + "\n";
					f.close();
					themes.append(ThemeInfo(*it, tdir.filePath(*it), info));
				}
			}
	}
	return themes;
}/*}}}*/

QIconSet& Icons::getIcon(int i)/*{{{*/
{
	return icon_user;
}/*}}}*/

