/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "chlist.h"
#include <qlayout.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>

ChannelList::ChannelList(): QStringList()/*{{{*/
{
}/*}}}*/

ChannelList::~ChannelList()/*{{{*/
{
}/*}}}*/

void ChannelList::add(const QString &name)/*{{{*/
{
	if (find(name)==end())
		append(name);
}/*}}}*/

void ChannelList::add(const QStringList &list)/*{{{*/
{
}/*}}}*/

bool ChannelList::del(const QString &name)/*{{{*/
{
	return remove(name)>0;
}/*}}}*/

QStringList ChannelList::list()/*{{{*/
{
	return *this;
}/*}}}*/

ChannelsDialog::ChannelsDialog(QWidget *parent, ChannelList *chlist): QDialog(parent)/*{{{*/
{
	setFixedSize(180, 300);
	setCaption("Channels");
	
	QBoxLayout *l1 = new QVBoxLayout(this, 0, 2);

	//
	// list of channels
	QListBox *lb_channels = new QListBox(this);
	lb_channels->insertStringList(chlist->list());
	lb_channels->sort();
	
	l1->addWidget(lb_channels);
	
	le_channel = new QLineEdit(this);
	QPushButton *b_join = new QPushButton("Join", this);
	
	QBoxLayout *l2 = new QHBoxLayout(l1, 2);
	l2->addWidget(le_channel);
	l2->addWidget(b_join);

	connect(lb_channels, SIGNAL(highlighted(const QString &)), le_channel, SLOT(setText(const QString &)));
	connect(b_join, SIGNAL(clicked()), this, SLOT(slotJoinClicked()));
}/*}}}*/

ChannelsDialog::~ChannelsDialog()/*{{{*/
{
}/*}}}*/

void ChannelsDialog::slotJoinClicked()/*{{{*/
{
	emit joinChannel(le_channel->text());
	close();
}/*}}}*/

