/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "chatlinehist.h"
#include <qlayout.h>
#include <qlistbox.h>
#include <qvbox.h>
#include <qpushbutton.h>

ChatLineHistory::ChatLineHistory(QWidget *parent, const QStringList &hist): QWidget(parent)/*{{{*/
{
	setWFlags(Qt::WDestructiveClose | Qt::WShowModal | getWFlags());
	setCaption("Commands history");
	resize(260, 400);
	
	QBoxLayout *l1 = new QVBoxLayout(this);

	QVBox *box1 = new QVBox(this);
	l1->addWidget(box1);
	
	hlb = new QListBox(box1);
	hlb->setSelectionMode(QListBox::Single);
	hlb->insertStringList(hist);
	hlb->setFocus();
	
	connect(hlb, SIGNAL(selected(QListBoxItem *)), this, SLOT(clicked(QListBoxItem *)));
	connect(hlb, SIGNAL(selected(QListBoxItem *)), this, SLOT(close()));
	
	QBoxLayout *l2 = new QHBoxLayout(l1);
	b_use = new QPushButton("Use", this);
	if (hist.count() == 0)
		b_use->setDisabled(true);
	QPushButton *b_close = new QPushButton("Close", this);

	connect(b_close, SIGNAL(clicked()), this, SLOT(close()));
	connect(b_use, SIGNAL(clicked()), this, SLOT(clickedUseButton()));
	connect(b_use, SIGNAL(clicked()), this, SLOT(close()));
	
	l2->addWidget(b_use);
	l2->addStretch(20);
	l2->addWidget(b_close);
}/*}}}*/

ChatLineHistory::~ChatLineHistory()/*{{{*/
{
}/*}}}*/

void ChatLineHistory::clicked(QListBoxItem *item)/*{{{*/
{
	emit clicked(item->text());
}/*}}}*/

void ChatLineHistory::clickedUseButton()/*{{{*/
{
	emit clicked(hlb->currentText());
}/*}}}*/

