/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "channel.h"
#include <qfont.h>
#include <qpopupmenu.h>
#include <qglobal.h>
#include <qhbox.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qtextstream.h>

Channel::Channel(QWidget *parent, const QString &n, const QString &topic, bool prv): QTextEdit(parent), activity(false), filename(QString::null)/*{{{*/
{
	this->prv = prv;
	chname = n;
	setReadOnly(true);
	setTextFormat(PlainText);
	setFocusPolicy(QWidget::NoFocus);
	setTopic(topic);
}/*}}}*/

Channel::Channel(QWidget *parent, const QString &n, bool prv): QTextEdit(parent)/*{{{*/
{
	this->prv = prv;
	chname = n;
	setReadOnly(true);
	setTextFormat(PlainText);
	setFocusPolicy(QWidget::NoFocus);
	setTopic(" ");
}/*}}}*/

Channel::~Channel()/*{{{*/
{
}/*}}}*/

void Channel::leave()/*{{{*/
{
	emit leave(chname);
}/*}}}*/

QPopupMenu* Channel::createPopupMenu(const QPoint &pos)/*{{{*/
{
	QPopupMenu *menu = new QPopupMenu(this);
	parentWidget();
	menu->insertItem(tr("Save"), this, SLOT(save()));
	menu->insertItem(tr("Save As"), this, SLOT(saveAs()));
	menu->insertSeparator();
	menu->insertItem(tr("Select all"), this, SLOT(selectAll()));
	menu->insertItem(tr("Copy"), this, SLOT(copy()));
	menu->insertItem(tr("Clear chat"), this, SLOT(clear()));
	menu->insertSeparator();
	menu->insertItem(tr("Leave"), this, SLOT(leave()));
	return menu;
}/*}}}*/

bool Channel::doSave()/*{{{*/
{
	QFile f(filename);
	if (!f.open(IO_WriteOnly))
		return false;
	QTextStream str(&f);
	str << text();
	f.close();
}/*}}}*/

void Channel::save()/*{{{*/
{
	if (filename.isNull())
		saveAs();
	doSave();
}/*}}}*/

void Channel::saveAs()/*{{{*/
{
	QString s = QFileDialog::getSaveFileName(QString::null, "Text files (*.txt)", this, 
			"open file dialog", "Choose a file to save" );
	if (!s.isNull())
		filename = s;
	doSave();
}/*}}}*/

