/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __UUID_H
#define __UUID_H

#include <qcstring.h>

#define UUID_LEN 16

class PacketData;
class QString;

class UUID: public QByteArray
{
	public:
		UUID();
		UUID(const QString &str);
		~UUID();

		void generate();
		void set(const unsigned char *data);
		bool set(const QString &str);
		QString asString() const;
};

#endif

