/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __ULIST_H
#define __ULIST_H

#include <qlistbox.h>
#include <qmap.h>
#include <qhostaddress.h>
#include "user.h"
#include "global.h"

class QPopupMenu;
class QStringList;

class UsersList: public QListBox
{
	Q_OBJECT
		
	private:
		typedef QMap<QString, User *> UserMap;
		UserMap umap;
		QPopupMenu *menu;
		QPopupMenu *usermenu;

	public:
		enum { ID_MESSAGE = ID_USERSLIST_MENU,
		       ID_REQINFO,
		       ID_PRVCHAT,
		       ID_BEEP,
		       ID_SAYNICK,
		       ID_MASSMESSAGE,
		       ID_REFRESH
		};

	private slots:
		void dummy();
		void popupContextMenu(QListBoxItem *it, const QPoint &p);
		void sendMessage(QListBoxItem *it);
		void menuAction(int i);
		
	signals:
		void sendMessage(const QString &nick);
		void sendMassMessage(const QStringList &nicks);
		void requestInfo(const QString &nick);
		void beep(const QString &nick);
		void privateChat(const QString &nick);
		void refresh();
		void sayNick(const QString &nick);

	public:
		UsersList(QWidget *);
		~UsersList();
		bool exists(const QString &nick) const { return umap.contains(nick); }
		User *getUser(const QString &nick) const { return exists(nick) ? umap[nick] : NULL; }
		bool newNick(const QString &onick, const QString &nnick);
		User *addUser(const QString &nick, char status, const QHostAddress &addr, char gender=0xff);
		bool delUser(const QString &nick);
		QHostAddress getIP(const QString &nick) const { return umap.contains(nick) ? umap[nick]->getIP() : QHostAddress(); }
		char getStatus(const QString &nick) const;
		char getStatus(User *user) const { return user->getStatus(); }
		bool setStatus(const QString &nick, char s);
		bool setStatus(User *user, char s) { return user->setStatus(s); }
		void clear() { umap.clear(); QListBox::clear(); }
		void decDeadCounters();
		int incDeadCounter(const QString &nick) { User *u=getUser(nick); return u!=NULL ? u->incDeadCounter() : -1; }
		QStringList getAllUsers() const;
};

#endif

