/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "status.h"
#include "history.h"
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlayout.h>

//StatusWin::StatusWin(QWidget *parent, const QString &name, const History &hist): QDialog(parent, NULL, true, WDestructiveClose)

StatusWin::StatusWin(QWidget *parent, const QString &name, const History &hist): QWidget(NULL)/*{{{*/
{
	setWFlags(Qt::WDestructiveClose | Qt::WShowModal | getWFlags());

	setCaption(name);
	
	infolist = new QComboBox(true, this);
	infolist->setMinimumWidth(260);
	infolist->setMaxCount(10);
	infolist->insertStringList(hist.getAll());
	
	b_ok = new QPushButton("OK", this);
	
	QBoxLayout *l1 = new QHBoxLayout(this);
	l1->addWidget(infolist);
	
	l1->addStretch(20);
	l1->addWidget(b_ok);
	connect(b_ok, SIGNAL(clicked()), this, SLOT(accept()));
	connect(b_ok, SIGNAL(clicked()), this, SLOT(close()));
}/*}}}*/

StatusWin::~StatusWin()/*{{{*/
{
}/*}}}*/

void StatusWin::accept()/*{{{*/
{
	emit changeStatus(infolist->currentText());
//	QDialog::accept();
}/*}}}*/

void StatusWin::closeEvent(QCloseEvent *e)/*{{{*/
{
	emit canceled();
	QWidget::closeEvent(e);
}/*}}}*/

