/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __REGEXP_H
#define __REGEXP_H

#include <qdialog.h>

class History;
class QComboBox;
class QCheckBox;
class QPushButton;

class RegexpWin: public QDialog
{
	Q_OBJECT
		
	private:
		QComboBox *infolist;
		QCheckBox *b_enable;
		QPushButton *b_ok;
		
	signals:
		void changeRegexp(const QString &txt, bool on);
		
	protected slots:
		virtual void accept();

	public:
		RegexpWin(QWidget *parent, const History &list, bool on);
		~RegexpWin();
};

#endif

