/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "regexp.h"
#include "history.h"
#include <qregexp.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qpushbutton.h>

RegexpWin::RegexpWin(QWidget *parent, const History &hist, bool on): QDialog(parent, NULL, true)/*{{{*/
{
	setCaption(tr("Regexp matching"));
	
	infolist = new QComboBox(true, this);
	infolist->setMinimumWidth(240);
	infolist->setMaxCount(10);
	infolist->insertStringList(hist.getAll());
	
	b_ok = new QPushButton(tr("OK"), this);
	b_enable = new QCheckBox(tr("Enable"), this);
	b_enable->setChecked(on);
	
	QBoxLayout *l1 = new QHBoxLayout(this, 0 ,5);
	l1->addWidget(infolist);
	l1->addWidget(b_enable);
	l1->addStretch(20);
	l1->addWidget(b_ok);
	connect(b_ok, SIGNAL(clicked()), this, SLOT(accept()));
}/*}}}*/

RegexpWin::~RegexpWin()/*{{{*/
{
}/*}}}*/

void RegexpWin::accept()/*{{{*/
{
	emit changeRegexp(infolist->currentText(), b_enable->isChecked());
	QDialog::accept();
}/*}}}*/

