/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __MSGSNDWIN_H
#define __MSGSNDWIN_H

#include <qwidget.h>

class QTextEdit;
class QPushButton;

class MessageSndWindow: public QWidget
{
	Q_OBJECT
		
	private slots:
		void sendPressed();
	
	signals:
		void send(const QString &nick, const QString &str);
		
	private:
		QString to;
		QTextEdit *msg;
		QPushButton *b_ok, *b_send;
		
	public:
		MessageSndWindow(const QString &to);
		virtual ~MessageSndWindow();
};

#endif

