/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "msgrcvwin.h"
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qlayout.h>

MessageRcvWindow::MessageRcvWindow(const QString &from, const QString &str): QWidget(NULL)/*{{{*/
{
	this->from = from;
	
	setWFlags(Qt::WDestructiveClose | getWFlags());
	setCaption(tr("Message from: ") + from);
	QBoxLayout *l1 = new QVBoxLayout(this);
	msg = new QTextEdit(this);
	rpl = new QTextEdit(this);
	msg->setReadOnly(true);
	msg->setTextFormat(PlainText);
	msg->setFocusPolicy(NoFocus);
	rpl->setTextFormat(PlainText);
	rpl->setFocus();
	l1->addWidget(msg);
	l1->addWidget(rpl);
	msg->append(str);
	
	QBoxLayout *bl = new QHBoxLayout(l1);
	b_reply = new QPushButton(tr("&Send reply"), this);
	b_chat = new QPushButton(tr("Chat"), this);
	b_ok = new QPushButton(tr("Close"), this);
	bl->addWidget(b_reply);
	bl->addStretch(20);
	bl->addWidget(b_chat);
	bl->addStretch(20);
	bl->addWidget(b_ok);
	
	setMinimumSize(280, 200);

	connect(b_reply, SIGNAL(clicked()), this, SLOT(replyPressed()));
	connect(b_chat, SIGNAL(clicked()), this, SLOT(chatPressed()));
	connect(b_ok, SIGNAL(clicked()), this, SLOT(close()));
}/*}}}*/

MessageRcvWindow::~MessageRcvWindow()/*{{{*/
{
}/*}}}*/

/*-----------------------------------------------------------------------------------------------------
 * 
 *                                            S L O T S
 *
 -----------------------------------------------------------------------------------------------------*/

void MessageRcvWindow::replyPressed()/*{{{*/
{
	if (!rpl->text().isEmpty())
		emit reply(from, rpl->text());
	close();
}/*}}}*/

void MessageRcvWindow::chatPressed()/*{{{*/
{
	emit chat(from);
	close();
}/*}}}*/

