/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __MASSMSGWIN_H
#define __MASSMSGWIN_H

#include <qwidget.h>

class QListBox;
class QTextEdit;
class QPushButton;
class QStringList;

class MassMessageWindow: public QWidget
{
	Q_OBJECT
	private slots:
		void sendPressed();
	
	signals:
		void send(const QStringList &nicks, const QString &str);
		
	private:
		QTextEdit *msg;
		QPushButton *b_ok, *b_send;
		QListBox *nicklist;

	public:
		MassMessageWindow(const QString &ownnick, const QStringList &nicks);
		~MassMessageWindow();
};

#endif

