/*
 * This file is a part of VyQChat.
 *
 * Copyright (C) 2002-2004 Pawel Stolowski <yogin@linux.bydg.org>
 *
 * VyQChat is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "chatline.h"

ChatLine::ChatLine(QWidget *parent, int max): QLineEdit(parent), histpos(0), histmax(max)/*{{{*/
{
}/*}}}*/

ChatLine::~ChatLine()/*{{{*/
{
}/*}}}*/

void ChatLine::paste()/*{{{*/
{
	QLineEdit::paste();
}/*}}}*/

void ChatLine::sayNick(const QString &nick)/*{{{*/
{
	setText(nick + ": ");
}/*}}}*/

void ChatLine::keyPressEvent(QKeyEvent *e)/*{{{*/
{
	if (e->key() == Qt::Key_Up)
	{
		if (--histpos < 0)
			histpos = hist.count();
		
		setText(hist[histpos]);
		return e->accept();
	}
	if (e->key() == Qt::Key_Down)
	{
		if (++histpos >= hist.count())
			histpos = 0;
		
		setText(hist[histpos]);
		return e->accept();
	}
	if (((e->key() == Qt::Key_Return) || (e->key() == Qt::Key_Enter)) && (!text().isEmpty()))
	{
		if (hist.count() >= histmax)
			hist.pop_front();
		hist.push_back(text());
		histpos = hist.count();
	}
	QLineEdit::keyPressEvent(e);
}/*}}}*/

QStringList ChatLine::getHistory() const/*{{{*/
{
	return hist;
}/*}}}*/

