#include "channelsdlg.h"
#include "chlist.h"
#include <qlayout.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qtooltip.h>

ChannelsDialog::ChannelsDialog(QWidget *parent, ChannelList *chlist): QDialog(parent)/*{{{*/
{
	setFixedSize(180, 300);
	setCaption(tr("Channels"));
	
	QBoxLayout *l1 = new QVBoxLayout(this, 0, 2);

	//
	// list of channels
	QListBox *lb_channels = new QListBox(this);
	lb_channels->insertStringList(chlist->list());
	lb_channels->sort();
	
	l1->addWidget(lb_channels);
	
	le_channel = new QLineEdit(this);
	QPushButton *b_join = new QPushButton(tr("Join"), this);
	
	QBoxLayout *l2 = new QHBoxLayout(l1, 2);
	l2->addWidget(le_channel);
	l2->addWidget(b_join);

	connect(lb_channels, SIGNAL(highlighted(const QString &)), le_channel, SLOT(setText(const QString &)));
	connect(b_join, SIGNAL(clicked()), this, SLOT(joinButtonClicked()));
	connect(lb_channels, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(doubleClicked(QListBoxItem *)));
}/*}}}*/

ChannelsDialog::~ChannelsDialog()/*{{{*/
{
}/*}}}*/

void ChannelsDialog::joinButtonClicked()/*{{{*/
{
	emit joinChannel(le_channel->text());
	close();
}/*}}}*/

void ChannelsDialog::doubleClicked(QListBoxItem *item)/*{{{*/
{
	if (item)
	{
		emit joinChannel(item->text());
		close();
	}
}/*}}}*/

