//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "track.h"

Track::Track(guint32 duration, Glib::ustring genre, Glib::ustring song_title, Glib::ustring artist_name, guint32 album_id, guint32 track_id, Glib::ustring license)
  :d_duration(duration), d_genre(genre), d_song_title(song_title), 
    d_artist_name(artist_name), d_album_id(album_id), d_track_id(track_id),
    d_license(license)
{
}

Track::Track(const Track& t)
  :d_duration(t.d_duration), d_genre(t.d_genre), d_song_title(t.d_song_title),
    d_artist_name(t.d_artist_name), d_album_id(t.d_album_id), 
    d_track_id(t.d_track_id), d_license(t.d_license)
{
}

Track::~Track()
{
}
