<?php
/*
 UWiKiCMS is a lightweight web content management system.
 Copyright (C) 2005, 2006, 2007, 2013 Christian Mauduit <ufoot@ufoot.org>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as
 published by the Free Software Foundation; either version 2 of
 the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public
 License along with this program; if not, write to the Free
 Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 MA  02110-1301  USA
*/

error_reporting(E_ALL ^ E_NOTICE); // setup by ./configure
include "version.php";

class UWC_Config {
  var $version = UWC_VERSION;

  var $siteurl = "http://localhost"; // setup by ./configure
  var $htprefix = "/uwikicms"; // setup by ./configure
  var $dbprefix = ""; // setup by ./configure
  var $dbhost = "localhost"; // setup by ./configure
  var $dbname = "uwikicms"; // setup by ./configure
  var $dbuser = "uwikicms"; // setup by ./configure
  var $dbpasswd = "x"; // setup by ./configure

  var $mcrypt_key = "12473d2433be79c428089b7da0241a7b"; // setup by ./configure
  var $mcrypt_iv = "6ca167cbd6ce5044"; // setup by ./configure

  var $prefix = "/"; // updated when object is constructed

  // Change these folders to customize the look'n'feel.
  var $images_dir = "/_uwikicms/template/images/default"; // setup by ./configure
  var $css_dir = "/_uwikicms/template/css/default"; // setup by ./configure

  // This name will appear at the bottom of each public page.
  var $copyright_holder = "Christian Mauduit"; // setup by ./configure

  var $session_lifetime = 10800; // 3 hours by default

  var $cache_time = 21600; // 6*3600, 6 hours by default
  var $cache_minsize = 1000; // 1k by default	
  var $cache_maxsize = 100000; // 100k by default	
  var $nocache_regex = "/(metaserver|start)\$/"; // pages matching this will not be cached

  var $debug = true; // setup by ./configure

  var $arrow_width=16; // icon size
  var $arrow_height=16; // icon size
  var $lang_width=24; // icon size
  var $lang_height=16; // icon size
  var $rss_width=16; // icon size
  var $rss_height=16; // icon size

  var $news_max_nb = 3; // max number of news (RSS within HTML)
  var $news_max_age = 92; // max age of news (RSS within HTML) in days
  var $rss_max_nb = 10; // max number of RSS itesm
  var $rss_max_age = 365; // max age of RSS items in days
  var $rss_max_len = 160; // max number of chars in RSS description

  var $control_focus=""; // free HTML on top of "control" box
  var $actions_focus=""; // free HTML on top of "actions" box

  function UWC_Config() {
    $this->prefix = dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "..";
  }
}
?>
