#!/bin/sh

. ~/.passwd

DST=/var/www/test/uwikicms/_uwikicms
rm -rf $DST
CWD=`dirname $0`

for site in blog ufo valerie vap www; do
    echo "Uploading "$site"..."
    $CWD/configure-$site.ufoot.org.sh
    $CWD/install.sh
    ncftpput -u $UFOOT_ORG_FTP_USER -p $UFOOT_ORG_FTP_PASSWD -R $UFOOT_ORG_FTP_SERVER /$site $DST
done

for site in adele lise; do
    echo "Uploading "$site"..."
    $CWD/configure-$site.ufoot.org.sh
    $CWD/install.sh
    ncftpput -u $UFOOT_ORG_FTP_USER -p $UFOOT_ORG_FTP_PASSWD -R $UFOOT_ORG_FTP_SERVER /$site/prive $DST
done

echo "Uploading demo..."
$CWD/configure-demo.free.fr.sh
$CWD/install.sh
ncftpput -u $UFOOT_FREE_FTP_USER -p $UFOOT_FREE_FTP_PASSWD -R $UFOOT_FREE_FTP_SERVER /uwikicmsdemo $DST

$CWD/configure-www.test.sh
$CWD/install.sh




