<?
/*
 Copyright (C) 2004 Christian Mauduit <ufoot@ufoot.org>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as
 published by the Free Software Foundation; either version 2 of
 the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public
 License along with this program; if not, write to the Free
 Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 MA 02111-1307 USA
*/

class UWC_Gallery     {
  var $data=null;
  var $path="";
  var $lang="";
  var $auth=null;
  var $status=3;
  var $status_updated=false;
  var $imagelist=null;
  var $imagelist_updated=false;

  function UWC_Gallery(&$data,$path,$lang,&$auth) {
    $this->data=& $data;
    $this->path=$path;
    $this->lang=$lang;
    $this->auth=& $auth;
  }

  function get_user_status() {
    return $this->auth->get_user_status();
  }

  function update_status_data() {
    if (!$this->status_updated) {
      $this->status_updated=true;
      $this->data->select_content_status_by_path_and_lang(uwc_content_get_parent_path($this->path),$this->lang);
      $row=$this->data->query_select_fetch_row();
      if ($row) {
	$this->status=(int) ($row["content_status"]);
      }      
    }
  }

  function update_imagelist_data() {
    if (!$this->imagelist_updated) {
      $this->imagelist_updated=true;
      $this->imagelist=new UWC_Imagelist(& $this->data, uwc_content_get_parent_path($this->path), $this->lang);
    }
  }

  function get_status() {
    $this->update_status_data();
    return $this->status;
  }

  function get_images_list() {
    $this->update_imagelist_data();
    if ($this->get_user_status()>=$this->get_status()) {
      return $this->imagelist->get_list();
    } else {
      return Array();
    }
  }

  function get_up() {
    /*
     * Ideally we should get the real title here
     */
    return array("path"=>uwc_content_get_parent_path($this->path),"title"=>"");
  }

  /*
   * Following functions are useless, but they're defined in case
   * there's some rights/auth error, so that PHP page can be
   * generated without any error...
   */
  function get_home() {
    return null;
  }

  function get_prev() {
    return null;
  }

  function get_next() {
    return null;
  }

  function get_parents() {
    return null;
  }

  function get_children() {
    return null;
  }

  function exists() {
    return true;
  }

  function get_date_update() {
    return null;
  }
}

function uwc_gallery_xul_header() {
  header('Content-Type: application/vnd.mozilla.xul+xml');
}

?>