<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html lang="<? echo $this->get_lang(); ?>">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
    <meta http-equiv="Content-Language" content="<? echo $this->get_lang(); ?>" />
    <title><? echo $this->get_title(); ?></title>
    <meta name="Author" content="<? echo $this->get_meta_author(); ?>" />
    <meta name="Description" content="<? echo $this->get_meta_description(); ?>" />
    <meta name="Keywords" content="<? echo $this->get_meta_keywords(); ?>" />
    <meta name="Copyright" content="<? echo $this->get_meta_copyright(); ?>" />
    <meta name="Generator" content="UWiKiCMS" />
    <link rel="stylesheet" type="text/css" media="screen" href="<? echo $this->get_css_dir(); ?>/style.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="<? echo $this->get_css_dir(); ?>/layout.css" />
    <link rel="stylesheet" type="text/css" media="print" href="<? echo $this->get_css_dir(); ?>/print.css" />
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
  </head>
  <body>

    <div id="title" class="default">
    <h1><? echo $this->get_title(); ?></h1>
    </div>

    <div id="control" class="box menu">

    <? if ($this->need_nav()) { ?>
    <div id="nav">
    <span class="textmode"> [ </span>

    <? if ($this->need_home()) { ?>
    <a href="<? echo $this->make_url($this->get_home_path()); ?>"><img src="<? echo $this->get_images_dir(); ?>/home.png" width="<? echo $this->get_arrow_width(); ?>" height="<? echo $this->get_arrow_height(); ?>" alt="<? echo sprintf($this->translate("home"),$this->get_home_title()); ?>" title="<? echo $this->get_home_title(); ?>" class="msiehackbox" /></a>
    <? } ?>

    <? if ($this->need_prev()) { ?>
    <span class="textmode"> | </span><a href="<? echo $this->make_url($this->get_prev_path()); ?>"><img src="<? echo $this->get_images_dir(); ?>/arrow_left.png" width="<? echo $this->get_arrow_width(); ?>" height="<? echo $this->get_arrow_height(); ?>" alt="<? echo sprintf($this->translate("prev"),$this->get_prev_title()); ?>" title="<? echo $this->get_prev_title(); ?>" class="msiehackbox" /></a>
    <? } ?>

    <? if ($this->need_up()) { ?>
    <span class="textmode"> | </span><a href="<? echo $this->make_url($this->get_up_path()); ?>"><img src="<? echo $this->get_images_dir(); ?>/arrow_up.png" width="<? echo $this->get_arrow_width(); ?>" height="<? echo $this->get_arrow_height(); ?>" alt="<? echo sprintf($this->translate("up"),$this->get_up_title()); ?>" title="<? echo $this->get_up_title(); ?>" class="msiehackbox" /></a>
    <? } ?>

    <? if ($this->need_next()) { ?>
    <span class="textmode"> | </span><a href="<? echo $this->make_url($this->get_next_path()); ?>"><img src="<? echo $this->get_images_dir(); ?>/arrow_right.png" width="<? echo $this->get_arrow_width(); ?>" height="<? echo $this->get_arrow_height(); ?>" alt="<? echo sprintf($this->translate("next"),$this->get_next_title()); ?>" title="<? echo $this->get_next_title(); ?>" class="msiehackbox" /></a>
    <? } ?>

    <span class="textmode"> ] </span>
    </div>
    <? } ?>

    <? $langs=$this->get_translated();
if (count($langs)>0) { 
  $first=true; ?>    
    <div id="langs">
    <span class="textmode"> [ </span>
    <? foreach ($langs as $lang) {
       if (!$first) { ?>
      <span class="textmode"> | </span>
    <? }
      $first=false; ?>
      <a href="<? echo $this->get_translate_url($lang); ?>"><img src="<? echo $this->get_images_dir()."/flag_".$lang.".png"; ?>" width="<? echo $this->get_lang_width(); ?>" height="<? echo $this->get_lang_height(); ?>" alt="<? echo $this->translate("view_lang_".$lang); ?>" title="<? echo $this->translate("view_lang_".$lang); ?>" class="msiehackbox" /></a>
    <? } ?>
    <span class="textmode"> ] </span>
    </div>
    <? } ?>

    <? if ($this->need_parents()) { ?>
    <div id="parents">
    <? foreach ($this->get_parents() as $parent) { ?>
    <a href="<? echo $this->make_url($parent["path"]); ?>">
<? 
   if ($parent["title"]) {
     echo uwc_format_text_to_html($parent["title"]);
   } else {
     echo $this->translate("no_title");
   }
?>
    </a> &gt; 
    <? } ?>
    <? echo $this->get_title(); ?>
    </div>
    <? } ?>

    <? if ($this->need_children()) {?>
    <div id="children">
    <ul>
    <? foreach ($this->get_children() as $child) { ?>
      <li> <a href="<? echo $this->make_url($child["path"]);?>">
<? 
   if ($child["title"]) {
     echo uwc_format_text_to_html($child["title"]);
   } else {
     echo $this->translate("no_title");
   }
?>
       </a></li>
    <? } ?>
    </ul>
    </div>
    <? } ?>

    </div>
