/* Copyright (c) 2011 - 2013 Daniel Thiele, Axel Wachtler
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.
 * Neither the name of the authors nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE. */

/**
 * @file
 *
 *
 *
 * @brief
 * @ingroup
 */

/* avr-libc inclusions */
#include <stdio.h>

/* uracoli inclusions */
#include <board.h>
#include <hif.h>

/* project inclusions */
#include "tlogger.h"

#if defined(ravrf230a) || defined(ravrf230b)
static FILE hif_stream = FDEV_SETUP_STREAM(hif_putc, hif_getc, _FDEV_SETUP_RW);

void measure_init_raven(void)
{
	hif_init(HIF_DEFAULT_BAUDRATE);
}

float measure_tmcu_raven(void)
{
#if 0
	char ln[80] = "########";
	char *p = ln;
	char c;

	while(EOF != fgetc(&hif_stream)); /* flush */

	fprintf(&hif_stream, "temp\n"); /* command to request temperature */

	/* wait for line */
	while( (c=fgetc(&hif_stream)) == EOF )
	{
		if(c != '\n'){
			*p++ = c;
		} else {
			*p = 0x00; /* Terminator */
			break;
		}
	}
#endif
	/* parse out temperature value */

	return 12.34;
}

float measure_vmcu_raven(void)
{
	return 4578.00;
}

#endif /* defined(ravrf230a) || defined(ravrf230b) */
/* EOF */
