/* Copyright (c) 2011 - 2013 Daniel Thiele, Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id$ */
/**
 * @file
 * @brief ....
 * @_addtogroup grpApp...
 */


/* === includes ============================================================ */
#include "meas.h"
/* === macros ============================================================== */

/* === types =============================================================== */

/* === globals ============================================================= */

/* === prototypes ========================================================== */

/* === functions =========================================================== */
void measure_init(void)
{
    #if defined(__AVR_ATmega128RFA1__)
        measure_init_rfa();
    #elif defined(ravrf230a) || defined(ravrf230b)
        measure_init_raven();
	#elif defined(__AVR_ATmega1281__)
		measure_init_m1281();
    #endif
}

float measure_tmcu(void)
{
    #if defined(__AVR_ATmega128RFA1__)
        return measure_tmcu_rfa();
    #elif defined(ravrf230a) || defined(ravrf230b)
        return measure_tmcu_raven();
	#elif defined(__AVR_ATmega1281__)
		/* not supported */
    #else
        return 0.0;
    #endif
}

float measure_vmcu(void)
{
    #if defined(__AVR_ATmega128RFA1__)
        return measure_vmcu_rfa();
    #elif defined(ravrf230a) || defined(ravrf230b)
        return measure_vmcu_raven();
	#elif defined(__AVR_ATmega1281__)
		measure_vmcu_m1281();
    #else
        return 0.0;
    #endif
}
