#   Copyright (c) 2011 - 2014 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id$

# === main parameters of the project =========================================
TOPDIR = ..
PROJECT = xmpl_sensor
CURRENT_MAKEFILE = xmpl_sensor.mk
BOARD = UNDEFINED
PART = UNDEFINED
APPNAME = "\"xmpl_sensor\""

OBJDIR = $(TOPDIR)/build
BINDIR = $(TOPDIR)/bin
LIBDIR = $(TOPDIR)/lib

# guessing the OS for a working (g)mkdir
ifndef MKDIR
    ifdef SystemRoot
        MKDIR=gmkdir -p
    else
        MKDIR=mkdir -p
    endif
endif

# === autogenerated board rules ========================================
help:
	@echo
	@echo "========================================================="
	@echo "Enter a board name or "all" for building the libraries.  "
	@echo "Have a look in the docu for what board you want to build."
	@echo "========================================================="
	@echo

all: any2400 any900 atrcb256rfr2xpro atzb256rfr2xpro atzbx212bxpro atzbx233xpro derfa1 derfn128 derfn128u0 derfn256u0 derfn256u0pa dracula l3y mnb900 pinoccio psk212 psk230 psk230b psk231 psk232 psk233 radiofaro radiofaro_v1 rbb128rfa1 rdk212 rdk230 rdk230b rdk231 rdk232 rdk233 sparcrfa1 stb128rfa1 stb212 stb230 stb230b stb231 stb232 stb233 stb256rfr2 wdba1281 wprog xme5rz212 xme5rz230 xme5rz231 zigduino

list:
	 @echo '  any2400          : A.N. Solutions ANY Brick'
	 @echo '  any900           : A.N. Solutions ANY Brick'
	 @echo '  atrcb256rfr2xpro : Atmel ATmega256RFR2 ZigBit Xplained Pro Extension'
	 @echo '  atzb256rfr2xpro  : Atmel ATmega256RFR2 ZigBit Xplained Pro Extension'
	 @echo '  atzbx212bxpro    : Atmel ZigBit (Module, USB Stick, Xplained Pro Extension)'
	 @echo '  atzbx233xpro     : Atmel ZigBit (Module, USB Stick, Xplained Pro Extension)'
	 @echo '  derfa1           : Dresden Elektronik Radio Module deRFmega128-22A001'
	 @echo '  derfn128         : Dresden Elektronik Radio Module deRFmega128-22A/M{00} on deRFnode, USB'
	 @echo '  derfn128u0       : Dresden Elektronik Radio Module deRFmega128-22A/M{00} on deRFnode, USB'
	 @echo '  derfn256u0       : Dresden Elektronik Radio Module deRFmega256-23M{00,10,12} on deRFnode, UART0 (X5)'
	 @echo '  derfn256u0pa     : Dresden Elektronik Radio Module deRFmega256-23M{00,10,12} on deRFnode, UART0 (X5)'
	 @echo '  dracula          : AirDMX gateway Dracula'
	 @echo '  l3y              : 2564rfr2 low cost module'
	 @echo '  mnb900           : Meshnetics MeshBean WDB-A1281 and MNZB-900 development boards'
	 @echo '  pinoccio         : Pinoccio - the ecosystem for the internet of things'
	 @echo '  psk212           : Atmel Packet Sniffer Kit, STK541 with RCB for AT86RF{212,23x}'
	 @echo '  psk230           : Atmel Packet Sniffer Kit, STK541 with RCB for AT86RF{212,23x}'
	 @echo '  psk230b          : Atmel Packet Sniffer Kit, STK541 with RCB for AT86RF{212,23x}'
	 @echo '  psk231           : Atmel Packet Sniffer Kit, STK541 with RCB for AT86RF{212,23x}'
	 @echo '  psk232           : Atmel Packet Sniffer Kit, STK541 with RCB for AT86RF{212,23x}'
	 @echo '  psk233           : Atmel Packet Sniffer Kit, STK541 with RCB for AT86RF{212,23x}'
	 @echo '  radiofaro        : RadioFaro, Arduino like board with deRFmega128-22A001'
	 @echo '  radiofaro_v1     : RadioFaro, Arduino like board with deRFmega128-22A001'
	 @echo '  rbb128rfa1       : Dresden Elektronik Breakout Board, with RCB for ATmega128RFA1'
	 @echo '  rdk212           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk230           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk230b          : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk231           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk232           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk233           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  sparcrfa1        : Sparcfun RFA1 Dev. Board by J. Lindblom'
	 @echo '  stb128rfa1       : Dresden Elektronik Sensor Terminal Board with RCB128RFA1'
	 @echo '  stb212           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb230           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb230b          : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb231           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb232           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb233           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb256rfr2       : Sensor Terminal Board with Atmel RCB256RFR2 Radio Controller Board'
	 @echo '  wdba1281         : Meshnetics MeshBean WDB-A1281 and MNZB-900 development boards'
	 @echo '  wprog            : WProg'
	 @echo '  xme5rz212        : Atmel RZ600 Stick plugged on J1 of Xmega-E5 Xplained'
	 @echo '  xme5rz230        : Atmel RZ600 Stick plugged on J1 of Xmega-E5 Xplained'
	 @echo '  xme5rz231        : Atmel RZ600 Stick plugged on J1 of Xmega-E5 Xplained'
	 @echo '  zigduino         : Zigduino made by Logos Electromechanical LLC'


any2400:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=any2400 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

any900:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=any900 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

atrcb256rfr2xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atrcb256rfr2xpro MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

atzb256rfr2xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzb256rfr2xpro MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

atzbx212bxpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzbx212bxpro MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

atzbx233xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzbx233xpro MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

derfa1:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfa1 MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

derfn128:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn128 MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

derfn128u0:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn128u0 MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

derfn256u0:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn256u0 MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

derfn256u0pa:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn256u0pa MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

dracula:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=dracula MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

l3y:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=l3y MCU=atmega2564rfr2 F_CPU=8000000UL $(TARGETS)

mnb900:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=mnb900 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

pinoccio:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=pinoccio MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

psk212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=psk212 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

psk230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=psk230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

psk230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=psk230b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

psk231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=psk231 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

psk232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=psk232 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

psk233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=psk233 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

radiofaro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=radiofaro MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

radiofaro_v1:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=radiofaro_v1 MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

rbb128rfa1:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rbb128rfa1 MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

rdk212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk212 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk230b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk231 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk232 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk233 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

sparcrfa1:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=sparcrfa1 MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

stb128rfa1:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb128rfa1 MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

stb212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb212 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb230b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb231 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb232 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb233 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb256rfr2:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb256rfr2 MCU=atmega256rfr2 F_CPU=8000000UL $(TARGETS)

wdba1281:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=wdba1281 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

wprog:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=wprog MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

xme5rz212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xme5rz212 MCU=atxmega32e5 F_CPU=8000000UL $(TARGETS)

xme5rz230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xme5rz230 MCU=atxmega32e5 F_CPU=8000000UL $(TARGETS)

xme5rz231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xme5rz231 MCU=atxmega32e5 F_CPU=8000000UL $(TARGETS)

zigduino:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=zigduino MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)


clean:
	rm -rf $(OBJDIR)/*.o $(OBJDIR)/*.lst $(BINDIR)/*.elf $(BINDIR)/*.hex

# === internal rules ===================================================

# temporary output directory
$(OBJDIR):
	$(MKDIR) $@

$(BINDIR):
	$(MKDIR) $@

TARGETS=$(OBJDIR) $(BINDIR) __xmpl_sensor__
SOURCES = xmpl_sensor.c
INCDIRS = . $(TOPDIR)/inc
LIBDIRS = $(TOPDIR)/lib
# DBGFMT=stabs for Linux
# DBGFMT=dwarf-2 for Windows
DBGFMT=
# automatically derived parameters
OBJECTS = $(SOURCES:%.c=$(OBJDIR)/%_$(BOARD).o)
TARGET = $(BINDIR)/$(PROJECT)_$(BOARD)

# === tool parameters ======================================================

CCFLAGS = -Wall -Wundef -Os -g$(DBGFMT) -ffunction-sections -fdata-sections -std=c99 -mmcu=$(MCU)
CCFLAGS += -Wa,-adhlns=$(<:%.c=$(OBJDIR)/%_$(BOARD).lst)
CCFLAGS += -D$(BOARD)
CCFLAGS += -DF_CPU=$(F_CPU)
CCFLAGS += -DAPP_NAME=$(APPNAME)
ifneq ($(baudrate),)
  CCFLAGS += -DHIF_DEFAULT_BAUDRATE=$(baudrate)
endif
CCFLAGS += -I$(TOPDIR)/inc -I.
LDFLAGS = $(patsubst %,-L%,$(LIBDIRS)) -Wl,--gc-sections -luracoli_$(BOARD)
OCFLAGS=-O ihex

# === custom settings ======================================================
# --- todo ---


# hier koennte ihre toolchain stehen!
ifeq ($(TC), AVR8)
   CC=avr-gcc
   AR=avr-ar
   RANLIB=avr-ranlib
   OBJCOPY=avr-objcopy
else ifeq ($(TC), ARM)
   CC=arm-none-eabi-gcc
   AR=arm-none-eabi-ar
   RANLIB=arm-none-eabi-ranlib
   OBJCOPY=arm-none-eabi-objcopy
else 
   CC=@echo undefined cc for $(TC)
   AR=@echo undefined ar for $(TC)
   RANLIB=@echo undefined ranlib for $(TC)
   OBJCOPY=@echo undefined objcopy for $(TC)
endif


# === build rules ============================================================

__xmpl_sensor__: $(TARGET).hex

$(TARGET).hex: $(TARGET).elf
	$(OBJCOPY) $(OCFLAGS) $< $@

$(TARGET).elf: $(OBJECTS) $(LIBDIRS)/liburacoli_$(BOARD).a
	$(CC) -o $@ $(CCFLAGS) $(OBJECTS) $(LDFLAGS)

$(OBJDIR)/%_$(BOARD).o: %.c
	$(CC) $(CCFLAGS) -c -o $@ $<

$(LIBDIRS)/liburacoli_$(BOARD).a:
	cd $(TOPDIR)/uracoli && make $(BOARD)
