#   Copyright (c) 2011 - 2014 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id$

# === main parameters of the project =========================================
TOPDIR = ..
PROJECT = xmpl_keys
CURRENT_MAKEFILE = xmpl_keys.mk
BOARD = UNDEFINED
PART = UNDEFINED
APPNAME = "\"xmpl_keys\""

OBJDIR = $(TOPDIR)/build
BINDIR = $(TOPDIR)/bin
LIBDIR = $(TOPDIR)/lib

# guessing the OS for a working (g)mkdir
ifndef MKDIR
    ifdef SystemRoot
        MKDIR=gmkdir -p
    else
        MKDIR=mkdir -p
    endif
endif

# === autogenerated board rules ========================================
help:
	@echo
	@echo "========================================================="
	@echo "Enter a board name or "all" for building the libraries.  "
	@echo "Have a look in the docu for what board you want to build."
	@echo "========================================================="
	@echo

all: atrcb256rfr2xpro atzb256rfr2xpro atzbx212bxpro atzbx233xpro cbb212 cbb230 cbb230b cbb231 cbb232 cbb233 rdk212 rdk230 rdk230b rdk231 rdk232 rdk233 stb212 stb230 stb230b stb231 stb232 stb233

list:
	 @echo '  atrcb256rfr2xpro : Atmel ATmega256RFR2 ZigBit Xplained Pro Extension'
	 @echo '  atzb256rfr2xpro  : Atmel ATmega256RFR2 ZigBit Xplained Pro Extension'
	 @echo '  atzbx212bxpro    : Atmel ZigBit (Module, USB Stick, Xplained Pro Extension)'
	 @echo '  atzbx233xpro     : Atmel ZigBit (Module, USB Stick, Xplained Pro Extension)'
	 @echo '  cbb212           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb230           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb230b          : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb231           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb232           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb233           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  rdk212           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk230           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk230b          : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk231           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk232           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk233           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  stb212           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb230           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb230b          : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb231           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb232           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb233           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'


atrcb256rfr2xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atrcb256rfr2xpro MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

atzb256rfr2xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzb256rfr2xpro MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

atzbx212bxpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzbx212bxpro MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

atzbx233xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzbx233xpro MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb212 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb230 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb230b MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb231 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb232 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb233 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

rdk212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk212 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk230b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk231 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk232 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk233 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb212 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb230b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb231 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb232 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb233 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)


clean:
	rm -rf $(OBJDIR)/*.o $(OBJDIR)/*.lst $(BINDIR)/*.elf $(BINDIR)/*.hex

# === internal rules ===================================================

# temporary output directory
$(OBJDIR):
	$(MKDIR) $@

$(BINDIR):
	$(MKDIR) $@

TARGETS=$(OBJDIR) $(BINDIR) __xmpl_keys__
SOURCES = xmpl_keys.c
INCDIRS = . $(TOPDIR)/inc
LIBDIRS = $(TOPDIR)/lib
# DBGFMT=stabs for Linux
# DBGFMT=dwarf-2 for Windows
DBGFMT=
# automatically derived parameters
OBJECTS = $(SOURCES:%.c=$(OBJDIR)/%_$(BOARD).o)
TARGET = $(BINDIR)/$(PROJECT)_$(BOARD)

# === tool parameters ======================================================

CCFLAGS = -Wall -Wundef -Os -g$(DBGFMT) -ffunction-sections -fdata-sections -std=c99 -mmcu=$(MCU)
CCFLAGS += -Wa,-adhlns=$(<:%.c=$(OBJDIR)/%_$(BOARD).lst)
CCFLAGS += -D$(BOARD)
CCFLAGS += -DF_CPU=$(F_CPU)
CCFLAGS += -DAPP_NAME=$(APPNAME)
ifneq ($(baudrate),)
  CCFLAGS += -DHIF_DEFAULT_BAUDRATE=$(baudrate)
endif
CCFLAGS += -I$(TOPDIR)/inc -I.
LDFLAGS = $(patsubst %,-L%,$(LIBDIRS)) -Wl,--gc-sections -luracoli_$(BOARD)
OCFLAGS=-O ihex

# === custom settings ======================================================
# --- todo ---


# hier koennte ihre toolchain stehen!
ifeq ($(TC), AVR8)
   CC=avr-gcc
   AR=avr-ar
   RANLIB=avr-ranlib
   OBJCOPY=avr-objcopy
else ifeq ($(TC), ARM)
   CC=arm-none-eabi-gcc
   AR=arm-none-eabi-ar
   RANLIB=arm-none-eabi-ranlib
   OBJCOPY=arm-none-eabi-objcopy
else 
   CC=@echo undefined cc for $(TC)
   AR=@echo undefined ar for $(TC)
   RANLIB=@echo undefined ranlib for $(TC)
   OBJCOPY=@echo undefined objcopy for $(TC)
endif


# === build rules ============================================================

__xmpl_keys__: $(TARGET).hex

$(TARGET).hex: $(TARGET).elf
	$(OBJCOPY) $(OCFLAGS) $< $@

$(TARGET).elf: $(OBJECTS) $(LIBDIRS)/liburacoli_$(BOARD).a
	$(CC) -o $@ $(CCFLAGS) $(OBJECTS) $(LDFLAGS)

$(OBJDIR)/%_$(BOARD).o: %.c
	$(CC) $(CCFLAGS) -c -o $@ $<

$(LIBDIRS)/liburacoli_$(BOARD).a:
	cd $(TOPDIR)/uracoli && make $(BOARD)
