/* Copyright (c) 2012 - 2013 Samuel Klipphahn
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: $ */
/**
 * @file
 * @brief Interface for lwMesh, MAC part
 * @ingroup grplwMesh
 */
#ifndef LWMAC_H
#define LWMAC_H

/**
 *  @addtogroup grplwMesh
 *  @{
 */
/* === includes ============================================================ */
#include "lw_mesh.h"
#include "const.h"
#include "board.h"
#include "transceiver.h"
#include "radio.h"

/* === macros ============================================================== */

/** address for broadcast frames */
#define NWK_BROADCAST_ADDR          (0xFFFF)

/** broadcast PAN ID for frames to all networks */
#define NWK_BROADCAST_PID           (0xFFFF)

/** MAC frame control field value for broadcast frames */
#define NWK_MAC_FCTL_BROADCAST  (0x8841)

/** MAC frame control field value for unicast frames */
#define NWK_MAC_FCTL_UNICAST    (0x8861)

/* === types =============================================================== */

/* === prototypes ========================================================== */
#ifdef __cplusplus
extern "C" {
#endif

void lwm_init(uint16_t pan_id, uint16_t short_addr, uint8_t channel);

radio_cca_t lwm_send_frame(uint8_t payload_size, NWK_FrameFormat_t *frame,
        uint8_t task_id, uint8_t options);

#ifdef __cplusplus
} /* extern "C" */
#endif

/**
 *  @}
 */
#endif  /* #ifndef LWMAC_H */
