/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.Theme;
import processing.app.debug.MessageConsumer;

public class SerialMonitor
extends JFrame
implements MessageConsumer {
    private Serial serial;
    private String port;
    private JTextArea textArea;
    private JTextField textField;
    private JButton sendButton;
    private JComboBox serialRates;
    private JLabel statusLabel;
    private int serialRate;

    public SerialMonitor(String string) {
        super(string);
        this.port = string;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SerialMonitor.this.closeSerialPort();
            }
        });
        KeyStroke keyStroke = Editor.WINDOW_CLOSE_KEYSTROKE;
        this.getRootPane().getInputMap(1).put(keyStroke, "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SerialMonitor.this.closeSerialPort();
                SerialMonitor.this.setVisible(false);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        Font font = Theme.getFont("console.font");
        this.textArea = new JTextArea(16, 40);
        this.textArea.setEditable(false);
        this.textArea.setFont(font);
        this.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
        JPanel jPanel = new JPanel(new BorderLayout(4, 0));
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.textField = new JTextField(40);
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
        this.sendButton = new JButton("Send");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
        jPanel.add((Component)this.textField, "Center");
        jPanel.add((Component)this.sendButton, "East");
        this.getContentPane().add((Component)jPanel, "North");
        jPanel = new JPanel(new BorderLayout(4, 0));
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.statusLabel = new JLabel();
        jPanel.add((Component)this.statusLabel, "Center");
        String[] stringArray = new String[]{"300", "1200", "2400", "4800", "9600", "14400", "19200", "28800", "38400", "57600", "115200"};
        this.serialRates = new JComboBox();
        for (int i = 0; i < stringArray.length; ++i) {
            this.serialRates.addItem(stringArray[i] + " baud");
        }
        this.serialRate = Preferences.getInteger("serial.debug_rate");
        this.serialRates.setSelectedItem(this.serialRate + " baud");
        this.serialRates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)SerialMonitor.this.serialRates.getSelectedItem();
                String string2 = string.substring(0, string.indexOf(32));
                SerialMonitor.this.serialRate = Integer.parseInt(string2);
                Preferences.set("serial.debug_rate", string2);
                SerialMonitor.this.closeSerialPort();
                SerialMonitor.this.openSerialPort();
            }
        });
        jPanel.add((Component)this.serialRates, "East");
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
    }

    private void send(String string) {
        if (this.serial != null) {
            this.serial.write(string);
        }
    }

    public void openSerialPort() {
        if (this.serial != null) {
            return;
        }
        try {
            this.statusLabel.setText("opening...");
            this.serial = new Serial(this.port, this.serialRate);
            this.serial.addListener(this);
            this.statusLabel.setText("");
        }
        catch (SerialException serialException) {
            this.statusLabel.setText(serialException.getMessage());
        }
    }

    public void closeSerialPort() {
        if (this.serial != null) {
            this.statusLabel.setText("closing...");
            this.textArea.setText("");
            this.serial.dispose();
            this.serial = null;
            this.statusLabel.setText("");
        }
    }

    public void message(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SerialMonitor.this.textArea.append(string);
            }
        });
    }
}

