/* Copyright (c) 2012 Daniel Thiele, Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

#ifndef CHSWEEP_H
#define CHSWEEP_H

/* === includes ============================================================ */

/* === macros ============================================================== */
#define EOL "\n"

#if defined(radiofaro)
# define DBG_LA_INIT() do{DDRE |=0xf0; PORTE &= ~0xf0;}while(0)
# define DBG_LA_SET(v) do{PORTE &= ~0xf0; PORTE |= ((v&0xf)<<4);}while(0)
#else
# define DBG_LA_INIT() do{}while(0)
# define DBG_LA_SET(v) do{}while(0)
#endif

#define TX_CYCLETIME_MS (20)
#define EQ_SIZE (1<<3)

/* === types =============================================================== */
typedef uint8_t cmdcode_t;

typedef enum
{
    STATE_IDLE,
    STATE_TX_SWEEP,
    STATE_RX_SWEEP,
    STATE_WAIT_PING,
} appstate_t;

typedef enum
{
    EVENT_NONE = '+',
    EVENT_SWEEP_TX_START = 'a',
    EVENT_SWEEP_TX = 'b',
    EVENT_SWEEP_TX_CHANNEL_SET = 'c',
    EVENT_TX_FAIL  = 'd',
    EVENT_SWEEP_RX_START  = 'e',
    EVENT_SWEEP_RX = 'f',
    EVENT_PING = 'g',
    EVENT_RX_PING = 'h',
    EVENT_RESULT_REQ = 'i',
    EVENT_RESULT_RX = 'j',
    EVENT_RESULT_OK = 'k',
    EVENT_TMO = 'l',
} event_t;

typedef struct
{
    uint8_t rd;
    uint8_t wr;
    event_t queue[EQ_SIZE];
} event_queue_t;

/* === prototypes ========================================================== */
#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif  /* #ifndef CHSWEEP_H */
