#   Copyright (c) 2007 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.
# $Id$

##
# This script builds two release packages
#  - uracoli*-src.tgz ... the source code only package
#  - uracoli*.tgz ....... package with precompiled documentation + source code
#
# Usage:
#   bash Tools/makerelease.sh <tagname>
#
#  <tagname> = snap : current HEAD is packed
#             X.Y.Z : is translated into cvs tagname  "r_X_Y_Z"
#                     X,Y,Z must be numeric values
#
RELBASE=/tmp
RELTAG=${1:-$(hg id --id)}
BUILDID=build_${RELTAG}_$(hg id --id)

# create build dir
test -d ${RELBASE} || mkdir -p ${RELBASE}

# make a hg archive
hg archive -r$RELTAG -I"uracoli/" -t zip ${BUILDID}.zip

# unpack and build packages
unzip -d $RELBASE $BUILDID.zip
(cd ${RELBASE}/$BUILDID/ && zip -r uracoli-devel-${RELTAG}.zip uracoli)
scons -C ${RELBASE}/$BUILDID/uracoli version=$RELTAG psrc

echo "Created $RELDIR in ${RELBASE}"
