/* Copyright (c) 2008 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: board_wdba1281.h,v 1.4 2008/07/31 05:10:30 awachtler Exp $ */
/**
 * @file
 * @brief Definitions for platform @ref grpWdba1281.
 * @defgroup grpWdba1281 WDB-A1281
 * @brief Meshnetics Meshbean Development Board WDB-A1281-(P1,A1,E2,Amp)
 *        with ATmega1281 and AT86RF230.
 *
 * See also
 * <a href="http://www.meshnetics.com/dev-tools/meshbean/"
 *  target="_ext">http://www.meshnetics.com/dev-tools/meshbean/</a>
 *
 * @ingroup grpBoard
 *
 * The wiring of the radio and the ATmega is shown below:
 *
<pre>
     AVR      RF230
     ---      -----
     PB4  -->  SLPTR
     PE5  <--  IRQ (INT5)
     PA7  -->  RSTN
     PB0  -->  SS
     PB2  -->  MOSI
     PB3  <--  MISO
     PB1  -->  SCK
     XTAL1 <--  MCLK

Fuses/Locks:
     LF: 0xe2 - 8MHz internal RC Osc.
     HF: 0x11 - without boot loader
     HF: 0x10 - with boot loader
     EF: 0xff
     LOCK: 0xef - protection of boot section

Bootloader:
    Start at byte=0x1e000, address=0xf000, size = 4096 instructions/ 8192 bytes

</pre>

 - Host Interface: @ref HIF_TYPE
 */

/**
 * \addtogroup grpWdba1281
 * @{
 *
 */
#define BOARD_NAME_WDBA1281 "wdba1281"

#ifndef BOARD_WDBA1281_H
#define BOARD_WDBA1281_H

#define BOARD_TYPE  WDB_A1281
#define BOARD_NAME  BOARD_NAME_WDBA1281

/*=== Compile time parameters ========================================*/
#ifndef MAX_FRAME_SIZE
# define MAX_FRAME_SIZE (127) /**< maximum allowed frame size */
#endif

/*=== radio interface definition =====================================*/
#include "boards/base_zdma1281.h"

/*=== LED access macros ==============================================*/
#define LED_PORT PORTB      /**< PORT register for LED */
#define LED_DDR  DDRB       /**< DDR register for LED */
#define LED_MASK 0xe0       /**< MASK value for LED */
#define LED_SHIFT     (5)   /**< SHIFT value for LED */
#define LEDS_INVERSE  (0)   /**< a 1 at the PORT means the LED is off */
#define LED_NUMBER    (3)   /**< number of LEDs for this board */

/*=== KEY access macros ==============================================*/
#define PORT_KEY PORTD
#define PIN_KEY  PIND
#define DDR_KEY  DDRD

#define MASK_KEY     (0xc0)
#define SHIFT_KEY    (6)
#define INVERSE_KEYS (1)
#define PULLUP_KEYS  (1)

/*=== Host Interface ================================================*/
/**
 * On the Meshbean board UART1 is routed either via a
 * FT232BM USB converter to connector CN1 or via a RS232 level
 * shifter to header P2. The selection is done with jumper J3.
 *
 */
#define HIF_TYPE (HIF_UART_1)

/*=== TIMER Interface ===============================================*/
/**
 * Mode: CTC
 * Prescaler: 8
 * Overflow: 0xFFFF
 */
#define HWTIMER_TICK    (8.0/F_CPU)
#define HWTIMER_TICK_NB (0xFFFFUL)
#define HWTIMER_REG     (TCNT1)
#define TIMER_TICK      (HWTIMER_TICK_NB * HWTIMER_TICK)
#define TIMER_POOL_SIZE (4)
#define TIMER_INIT() \
    do{ \
        TCCR1B |= (_BV(CS10));\
        TIMSK1 |= _BV(TOIE1); \
    }while(0)
#define TIMER_IRQ_vect  TIMER1_OVF_vect


/*=== OSCCAL tuning =================================================*/

#ifndef TUNED_OSCCAL
# define TUNED_OSCCAL (0xbf)  /* default is 0xb1, but @2.9V 0xbf is better */
#endif
#endif /** @} BOARD_WDBA1281_H*/
