/* Copyright (c) 2007 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: const.h,v 1.1 2008/03/21 11:14:25 awachtler Exp $ */
/**
 * @file
 * @brief Constant definitions
 *
 */
/*====================================================================*/
#ifndef CONST_H
#define CONST_H

/**
 * @ingroup grpGenConst
 * @{
 */
/*=== board constants ================================================*/
#define  STK500_MEGA8    (1) /**< Board description see @ref grpSTKM8 . */
#define  STK500_MEGA16   (2) /**< Board description see @ref grpSTKM16 . */
//#define  IC_MEGA8_8      (3) /**< Board description see @ref grpICM8 . */
#define  ICT_RF230       (4) /**< Board description see @ref grpICT230 . */
#define  RDK_230         (5) /**< Board description see @ref grpRDK230 . */
#define  STK_541         (6) /**< Board description see @ref grpSTK541 . */
#define  STK500_TINY26   (7) /**< Board description see @ref grpSTKT26 . */
/*=== cpu constants ==================================================*/
#define  CPU_M8          (1) /**< Identifier for CPU ATmega8 */
#define  CPU_M16         (2) /**< Identifier for CPU ATmega16 */
#define  CPU_M1281       (3) /**< Identifier for CPU ATmega1281 */
#define  CPU_T26         (4) /**< Identifier for CPU ATtiny26 */

/*=== radio constants ================================================*/
#define  RADIO_AT86RF230 (1) /**< Identifier for radio AT86RF230 */

/*=== HIF type constants =============================================*/
#define  HIF_NONE     (0)  /**< Identifier for no host interface */


#define  HIF_UART_0   (10) /**< Identifier for host interface of type UART 0 */
#define  HIF_UART_1   (11) /**< Identifier for host interface of type UART 1 */
#define  HIF_FT245    (20) /**< Identifier for host interface of FT245 type */

/*=== spi constants ==================================================*/
#define SPI_RATE_1_2      (4) /**< SPI clock running is 0.5 (1/2) of cpu clock */
#define SPI_RATE_1_4      (0) /**< SPI clock running is 0.25 (1/4) of cpu clock */
#define SPI_RATE_1_8      (5) /**< SPI clock running is 0.125 (1/8) of cpu clock */
#define SPI_RATE_1_16     (1) /**< SPI clock running is 0.0635 (1/16) of cpu clock */
#define SPI_RATE_1_32     (6) /**< SPI clock running is 0.03125 (1/32)of cpu clock */
#define SPI_RATE_1_64     (2) /**< SPI clock running is 0.015625 (1/64)of cpu clock */
#define SPI_RATE_1_128    (3) /**< SPI clock running is 0.0078125 (1/128) of cpu clock */



#if defined (DOXYGEN)
/** macro that forces an enumeration to use 8 bit instead of 16 bit integers. */
#define SHORTENUM
#else
#define SHORTENUM  __attribute__ ((packed))
#endif

/** @} */
#endif  /* #ifndef CONST_H */
