/* Copyright (c) 2007 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: board_rdk230.h,v 1.1 2008/03/21 11:14:27 awachtler Exp $ */
/**
 * @defgroup grpRDK230 RDK230
 * @brief Atmel Radio Development Kit, AT86RF230 Radio Adapter with Atmega1281.
 *
 * @ingroup grpBoard
 *
 * This board wiring fits the Atmel radio development kit
 * hardware and compatibles, e.g. the In-Cirquit
 * ICradio Stick|Module 2.4G series.
 *
 * The wiring of the radio and the ATmega is shown below:
 *
<pre>
     AVR      RF230
     ---      -----
     PB4  -->  SLPTR
     P??  <--  MCLK
     PD4  <--  IRQ (ICP1)
     PB5  -->  RSTN
     PB0  -->  SS
     PB2  -->  MOSI
     PB3  <--  MISO
     PB1  -->  SCK


Fuses/Locks:
     LF: 0xe2 - 8MHz internal RC Osc.
     HF: 0x11 - without boot loader
     HF: 0x10 - with boot loader
     EF: 0xff
     LOCK: 0xef - protection of boot section

Bootloader:
    Start at byte=0x1e000, address=0xf000, size = 4096 instructions/ 8192 bytes

</pre>

 @image html atmel_stk50x.jpg "STK500 + STK501 + Radio board"
 @image latex atmel_stk50x.jpg "STK500 + STK501 + Radio board"
 */
#define BOARD_NAME_RDK230 "rdk230"

#ifndef BOARD_RDK230_H
#define BOARD_RDK230_H

#define BOARD_TYPE  RDK_230
#define BOARD_NAME  BOARD_NAME_RDK230

/*=== Compile time parameters ========================================*/
#ifndef MAX_FRAME_SIZE
# define MAX_FRAME_SIZE (127) /**< maximum allowed frame size */
#endif

#ifndef F_CPU
# error "F_CPU is undefined"
#endif

/*=== radio interface definition =====================================*/
#include "base_rdk230.h"

/*=== LED access macros ==============================================*/
#define PORT_LED PORTD      /**< PORT register for LED */
#define DDR_LED  DDRD       /**< DDR register for LED */
#define MASK_LED 0xc0       /**< MASK value for LED */
#define SHIFT_LED     (6)   /**< SHIFT value for LED */
#define INVERSE_LEDS  (1)

/*=== KEY access macros ==============================================*/
#define PORT_KEY PORTD
#define PIN_KEY  PIND
#define DDR_KEY  DDRD

#define MASK_KEY     (0x01)
#define SHIFT_KEY    (0)
#define INVERSE_KEYS (1)
#define PULLUP_KEYS  (1)

/*=== Host Interface ================================================*/
#define HIF_TYPE (HIF_UART_1)

/*=== TIMER Interface ===============================================*/
#define  TIMER_TICK (0xFFFFUL * 1000.0 / F_CPU) /** tick value in ms*/
# define TIMER_POOL_SIZE  (4)
# define TIMER_INIT() \
    do{ \
        TCCR1B |= (_BV(CS10)); \
        TIMSK1 |= _BV(TOIE1); \
    }while(0)
# define TIMER_IRQ_vect   TIMER1_OVF_vect

/*=== OSCCAL tuning =================================================*/

#ifndef TUNED_OSCCAL
# define TUNED_OSCCAL (0xbf)  /* default is 0xb1, but @2.9V 0xbf is better */
#endif
#endif /*BOARD_RDK230_H*/
