/* Copyright (c) 2009 
    Daniel Thiele, 
    Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

#ifndef ACC_MMA7455_H
#define ACC_MMA7455_H

/* === includes ============================================================ */
#include "mma7455.h"

/* === macros ============================================================== */

/* possible values for subregister MODE[1:0] */
#define ACC_MODE_STANDBY        (0x01)
#define ACC_MODE_MEASURE        (0x02)
#define ACC_MODE_LEVELDETECT    (0x03)
#define ACC_MODE_PULSEDETECT    (0x04)

/* possible values for subregister GLVL[1:0] */
#define ACC_RANGE_2G            (0x01)
#define ACC_RANGE_4G            (0x02)
#define ACC_RANGE_8G            (0x00)

/* === types =============================================================== */

/* === prototypes ========================================================== */
#ifdef __cplusplus
extern "C" {
#endif
uint8_t acc_regrd(uint8_t addr);
uint8_t acc_regrd_multiple(uint8_t addr, uint8_t count, uint8_t *buffer);
uint8_t acc_regwr(uint8_t addr, uint8_t data);

void acc_init();
void acc_setmode(uint8_t mode);
#ifdef __cplusplus
} /* extern "C" */
#endif

#endif  /* #ifndef ACC_MMA7455_H */
/** EOF */
