/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import processing.app.Base;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;

public class Theme {
    static HashMap<String, String> defaults;
    static HashMap<String, String> table;

    protected static void init() {
        try {
            Theme.load(Base.getLibStream("theme/theme.txt"));
        }
        catch (Exception exception) {
            Base.showError(null, "Could not read color theme settings.\nYou'll need to reinstall Processing.", exception);
        }
        String string = "." + Base.getPlatformName();
        int n = string.length();
        for (String string2 : table.keySet()) {
            if (!string2.endsWith(string)) continue;
            String string3 = string2.substring(0, string2.length() - n);
            String string4 = Theme.get(string2);
            table.put(string3, string4);
        }
        Theme.setColor("run.window.bgcolor", SystemColor.control);
        defaults = (HashMap)table.clone();
    }

    protected static void load(InputStream inputStream) throws IOException {
        String[] stringArray;
        for (String string : stringArray = PApplet.loadStrings((InputStream)inputStream)) {
            int n;
            if (string.length() == 0 || string.charAt(0) == '#' || (n = string.indexOf(61)) == -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            table.put(string2, string3);
        }
    }

    public static String get(String string) {
        return table.get(string);
    }

    public static String getDefault(String string) {
        return defaults.get(string);
    }

    public static void set(String string, String string2) {
        table.put(string, string2);
    }

    public static boolean getBoolean(String string) {
        String string2 = Theme.get(string);
        return new Boolean(string2);
    }

    public static void setBoolean(String string, boolean bl) {
        Theme.set(string, bl ? "true" : "false");
    }

    public static int getInteger(String string) {
        return Integer.parseInt(Theme.get(string));
    }

    public static void setInteger(String string, int n) {
        Theme.set(string, String.valueOf(n));
    }

    public static Color getColor(String string) {
        Color color = null;
        String string2 = Theme.get(string);
        if (string2 != null && string2.indexOf("#") == 0) {
            try {
                int n = Integer.parseInt(string2.substring(1), 16);
                color = new Color(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return color;
    }

    public static void setColor(String string, Color color) {
        Theme.set(string, "#" + PApplet.hex((int)(color.getRGB() & 0xFFFFFF), (int)6));
    }

    public static Font getFont(String string) {
        String[] stringArray;
        boolean bl = false;
        String string2 = Theme.get(string);
        if (string2 == null) {
            string2 = Theme.getDefault(string);
            bl = true;
        }
        if ((stringArray = PApplet.split((String)string2, (char)',')).length != 3) {
            string2 = Theme.getDefault(string);
            stringArray = PApplet.split((String)string2, (char)',');
            bl = true;
        }
        String string3 = stringArray[0];
        int n = 0;
        if (stringArray[1].indexOf("bold") != -1) {
            n |= 1;
        }
        if (stringArray[1].indexOf("italic") != -1) {
            n |= 2;
        }
        int n2 = PApplet.parseInt((String)stringArray[2], (int)12);
        Font font = new Font(string3, n, n2);
        if (bl) {
            Theme.set(string, string2);
        }
        return font;
    }

    public static SyntaxStyle getStyle(String string) {
        String string2 = Theme.get("editor." + string + ".style");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = stringTokenizer.nextToken();
        if (string3.indexOf("#") == 0) {
            string3 = string3.substring(1);
        }
        Color color = new Color(Integer.parseInt(string3, 16));
        string3 = stringTokenizer.nextToken();
        boolean bl = string3.indexOf("bold") != -1;
        boolean bl2 = string3.indexOf("italic") != -1;
        return new SyntaxStyle(color, bl2, bl);
    }

    static {
        table = new HashMap();
    }
}

