/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Theme;

public class EditorHeader
extends JComponent {
    static Color backgroundColor;
    static Color[] textColor;
    Editor editor;
    int[] tabLeft;
    int[] tabRight;
    Font font;
    FontMetrics metrics;
    int fontAscent;
    JMenu menu;
    JPopupMenu popup;
    int menuLeft;
    int menuRight;
    static final String[] STATUS;
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    static final String[] WHERE;
    static final int LEFT = 0;
    static final int MIDDLE = 1;
    static final int RIGHT = 2;
    static final int MENU = 3;
    static final int PIECE_WIDTH = 4;
    static Image[][] pieces;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;

    public EditorHeader(Editor editor) {
        this.editor = editor;
        if (pieces == null) {
            pieces = new Image[STATUS.length][WHERE.length];
            for (int i = 0; i < STATUS.length; ++i) {
                for (int j = 0; j < WHERE.length; ++j) {
                    String string = "tab-" + STATUS[i] + "-" + WHERE[j] + ".gif";
                    EditorHeader.pieces[i][j] = Base.getThemeImage(string, this);
                }
            }
        }
        if (backgroundColor == null) {
            backgroundColor = Theme.getColor("header.bgcolor");
            EditorHeader.textColor[1] = Theme.getColor("header.text.selected.color");
            EditorHeader.textColor[0] = Theme.getColor("header.text.unselected.color");
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (n > EditorHeader.this.menuLeft && n < EditorHeader.this.menuRight) {
                    EditorHeader.this.popup.show(EditorHeader.this, n, n2);
                } else {
                    Sketch sketch = EditorHeader.this.editor.getSketch();
                    for (int i = 0; i < sketch.getCodeCount(); ++i) {
                        if (n <= EditorHeader.this.tabLeft[i] || n >= EditorHeader.this.tabRight[i]) continue;
                        sketch.setCurrentCode(i);
                        EditorHeader.this.repaint();
                    }
                }
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Sketch sketch = this.editor.getSketch();
        if (sketch == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.width != this.sizeW || dimension.height != this.sizeH) {
            if (dimension.width > this.imageW || dimension.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = dimension.width;
                this.sizeH = dimension.height;
            }
        }
        if (this.offscreen == null) {
            this.sizeW = dimension.width;
            this.sizeH = dimension.height;
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        if (this.font == null) {
            this.font = Theme.getFont("header.text.font");
        }
        graphics2.setFont(this.font);
        this.metrics = graphics2.getFontMetrics();
        this.fontAscent = this.metrics.getAscent();
        graphics2.setColor(backgroundColor);
        graphics2.fillRect(0, 0, this.imageW, this.imageH);
        int n = sketch.getCodeCount();
        if (this.tabLeft == null || this.tabLeft.length < n) {
            this.tabLeft = new int[n];
            this.tabRight = new int[n];
        }
        int n2 = 6;
        for (int i = 0; i < sketch.getCodeCount(); ++i) {
            int n3;
            SketchCode sketchCode = sketch.getCode(i);
            String string = sketch.hideExtension(sketchCode.getExtension()) ? sketchCode.getPrettyName() : sketchCode.getFileName();
            String string2 = "  " + string + (sketchCode.isModified() ? " \u00a7" : "  ");
            Graphics2D graphics2D = (Graphics2D)graphics2;
            int n4 = (int)this.font.getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth();
            int n5 = 2 + n4 / 4;
            int n6 = n5 * 4;
            int n7 = sketchCode == sketch.getCurrentCode() ? 1 : 0;
            graphics2.drawImage(pieces[n7][0], n2, 0, null);
            int n8 = n2 += 4;
            this.tabLeft[i] = n2;
            for (n3 = 0; n3 < n5; ++n3) {
                graphics2.drawImage(pieces[n7][1], n2, 0, null);
                n2 += 4;
            }
            this.tabRight[i] = n2;
            n3 = n8 + (n6 - n4) / 2;
            graphics2.setColor(textColor[n7]);
            int n9 = (this.sizeH + this.fontAscent) / 2;
            graphics2.drawString(string2, n3, n9);
            graphics2.drawImage(pieces[n7][2], n2, 0, null);
            n2 += 3;
        }
        this.menuLeft = this.sizeW - (16 + pieces[0][3].getWidth(this));
        this.menuRight = this.sizeW - 16;
        graphics2.drawImage(pieces[this.popup.isVisible() ? 1 : 0][3], this.menuLeft, 0, null);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void rebuild() {
        this.rebuildMenu();
        this.repaint();
        Toolkit.getDefaultToolkit().sync();
    }

    public void rebuildMenu() {
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu();
            this.popup = this.menu.getPopupMenu();
            this.add(this.popup);
            this.popup.setLightWeightPopupEnabled(true);
        }
        JMenuItem jMenuItem = Editor.newJMenuItemShift("New Tab", 78);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorHeader.this.editor.getSketch().handleNewCode();
            }
        });
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorHeader.this.editor.getSketch().handleRenameCode();
            }
        });
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorHeader.this.editor.getSketch().handleDeleteCode();
            }
        });
        this.menu.add(jMenuItem);
        this.menu.addSeparator();
        jMenuItem = new JMenuItem("Previous Tab");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(37, Editor.SHORTCUT_ALT_KEY_MASK);
        jMenuItem.setAccelerator(keyStroke);
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Next Tab");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(39, Editor.SHORTCUT_ALT_KEY_MASK);
        jMenuItem.setAccelerator(keyStroke2);
        this.menu.add(jMenuItem);
        Sketch sketch = this.editor.getSketch();
        if (sketch != null) {
            this.menu.addSeparator();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EditorHeader.this.editor.getSketch().setCurrentCode(actionEvent.getActionCommand());
                }
            };
            for (SketchCode sketchCode : sketch.getCode()) {
                jMenuItem = new JMenuItem(sketchCode.isExtension(sketch.getDefaultExtension()) ? sketchCode.getPrettyName() : sketchCode.getFileName());
                jMenuItem.setActionCommand(sketchCode.getFileName());
                jMenuItem.addActionListener(actionListener);
                this.menu.add(jMenuItem);
            }
        }
    }

    public void deselectMenu() {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (Base.isMacOS()) {
            return new Dimension(300, 33);
        }
        return new Dimension(300, 32);
    }

    public Dimension getMaximumSize() {
        if (Base.isMacOS()) {
            return new Dimension(3000, 33);
        }
        return new Dimension(3000, 32);
    }

    static {
        textColor = new Color[2];
        STATUS = new String[]{"unsel", "sel"};
        WHERE = new String[]{"left", "mid", "right", "menu"};
    }
}

