/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.colorchooser;

import ch.randelshofer.quaqua.colorchooser.ColorWheelImageProducer;
import ch.randelshofer.quaqua.colorchooser.HSBColorSliderModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorWheel
extends JPanel {
    protected Insets wheelInsets = new Insets(0, 0, 0, 0);
    private Image colorWheelImage;
    protected ColorWheelImageProducer colorWheelProducer;
    protected HSBColorSliderModel model = new HSBColorSliderModel();
    private MouseHandler mouseHandler;
    private ModelHandler modelHandler;

    public ColorWheel() {
        this.initComponents();
        this.colorWheelProducer = this.createWheelProducer(0, 0);
        this.modelHandler = new ModelHandler();
        this.model.addChangeListener(this.modelHandler);
        this.installMouseListeners();
        this.setOpaque(false);
    }

    protected void installMouseListeners() {
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
    }

    public void setModel(HSBColorSliderModel m) {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelHandler);
        }
        this.model = m;
        if (this.model != null) {
            this.model.addChangeListener(this.modelHandler);
            this.repaint();
        }
    }

    public void setWheelInsets(Insets newValue) {
        this.wheelInsets = newValue;
        this.repaint();
    }

    public Insets getWheelInsets() {
        return this.wheelInsets;
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public HSBColorSliderModel getModel() {
        return this.model;
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        this.paintWheel(g);
        this.paintThumb(g);
    }

    protected ColorWheelImageProducer createWheelProducer(int w, int h) {
        return new ColorWheelImageProducer(w, h);
    }

    protected void paintWheel(Graphics2D g) {
        int w = this.getWidth() - this.wheelInsets.left - this.wheelInsets.right;
        int h = this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom;
        if (this.colorWheelImage == null || this.colorWheelImage.getWidth(this) != w || this.colorWheelImage.getHeight(this) != h) {
            if (this.colorWheelImage != null) {
                this.colorWheelImage.flush();
            }
            this.colorWheelProducer = this.createWheelProducer(w, h);
            this.colorWheelImage = this.createImage(this.colorWheelProducer);
        }
        this.colorWheelProducer.setBrightness((float)this.model.getValue(2) / 100.0f);
        this.colorWheelProducer.regenerateColorWheel();
        g.drawImage(this.colorWheelImage, this.wheelInsets.left, this.wheelInsets.top, this);
    }

    protected void paintThumb(Graphics2D g) {
        Point p = this.getThumbLocation();
        g.setColor(Color.white);
        g.fillRect(p.x - 1, p.y - 1, 2, 2);
        g.setColor(Color.black);
        g.drawRect(p.x - 2, p.y - 2, 3, 3);
    }

    protected Point getThumbLocation() {
        return this.getColorLocation((float)this.model.getValue(0) / 360.0f, (float)this.model.getValue(1) / 100.0f, (float)this.model.getValue(2) / 100.0f);
    }

    protected Point getCenter() {
        int w = this.getWidth() - this.wheelInsets.left - this.wheelInsets.right;
        int h = this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom;
        return new Point(this.wheelInsets.left + w / 2, this.wheelInsets.top + h / 2);
    }

    protected Point getColorLocation(Color c) {
        Point p = this.colorWheelProducer.getColorLocation(c, this.getWidth() - this.wheelInsets.left - this.wheelInsets.right, this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom);
        p.x += this.wheelInsets.left;
        p.y += this.wheelInsets.top;
        return p;
    }

    protected Point getColorLocation(float hue, float saturation, float brightness) {
        Point p = this.colorWheelProducer.getColorLocation(hue, saturation, brightness, this.getWidth() - this.wheelInsets.left - this.wheelInsets.right, this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom);
        p.x += this.wheelInsets.left;
        p.y += this.wheelInsets.top;
        return p;
    }

    protected float[] getColorAt(int x, int y) {
        return this.colorWheelProducer.getColorAt(x - this.wheelInsets.left, y - this.wheelInsets.top, this.getWidth() - this.wheelInsets.left - this.wheelInsets.right, this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class ModelHandler
    implements ChangeListener {
        private ModelHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            ColorWheel.this.repaint();
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            this.update(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.update(e);
        }

        private void update(MouseEvent e) {
            float[] hsb = ColorWheel.this.getColorAt(e.getX(), e.getY());
            ColorWheel.this.model.setValue(0, (int)(360.0f * hsb[0]));
            ColorWheel.this.model.setValue(1, (int)(100.0f * hsb[1]));
            ColorWheel.this.repaint();
        }
    }
}

