(define stow-package
  (lambda (package-dir version)
    (if (exec (string-append "cd " package-dir
			     "; " stow " --no-folding -t "
			     package-install-dir " -S " version))
	(statusmsg (_ "Stowed package directory") package-dir)
	(errormsg (_ "Could not stow package directory") package-dir 'fatal))))

(define unstow-package
  (lambda (package-dir version)
    (if (exec (string-append "cd " package-dir
			     "; " stow " --no-folding -t "
			     package-install-dir " -D " version))
	(statusmsg (_ "Unstowed package directory") package-dir)
	(errormsg (_ "Could not unstow package directory") package-dir 'fatal))))
