/* Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>

   This file is part of Upmf.

   Upmf is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   Upmf is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with Upmf.  If not, see <http://www.gnu.org/licenses/>. */

#include <config.h>
#include <gettext.h>
#include "version-comp.h"

static void
inner_main (void *closure, int argc, char **argv);

int
main (int argc, char **argv)
{
#ifdef ENABLE_NLS
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
  bindtextdomain (PACKAGE "-gnulib", LOCALEDIR);
#endif

  scm_boot_guile (argc, argv, inner_main, 0);
  return 0;
}

static void
inner_main (void *closure, int argc, char **argv)
{    
  init_version_functions ();
  scm_primitive_load_path (scm_from_locale_string ("upmf/basic.scm"));
}
