;; Scheme frontends for various programs: patch, tar

;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

(define errormsg
  (lambda (message fatal)
    (display (string-append (list-ref (command-line) 0) ": " message))
    (newline)
    (if (eq? fatal 'fatal)
	(quit))))

(define statusmsg
  (lambda* (message #:optional append-str)
	   (if (eq? append-str #f)
	       (begin (display (string-append ">> " message))
		      (newline))
	       (begin (display (string-append ">> " message
					      ": "  append-str))
		      (newline)))))

;; Execute shell COMMAND
(define exec
  (lambda (command)
    (let ((pipe (open-pipe command OPEN_WRITE)))
      (if (eq? (close-pipe pipe) 0)
	  #t
	  #f))))

(define patch
  (lambda (directory patch)
    (statusmsg (_ "Applying patch") patch)
    (newline)
    (if (exec (string-append "patch -d " directory
			     " -Np1 " patch ".patch"))
	(statusmsg (_ "Patch successfully applied."))
	(errormsg (string-append (_ "Failed to apply patch: ") patch) 'fatal))))

(define tar-extract
  (lambda (archive-file dest-dir)
    (statusmsg (_ "Extracting archive") archive-file)
    (if (exec (string-append "tar -xf " archive-file " -C " dest-dir))
	(statusmsg (_ "Archive file successfully extracted."))
	(errormsg (string-append (_ "Failed to extract archive: ")
				 archive-file) 'fatal))))
