;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

;; Determine if the extracted source archive has a top level directory.
;; DIRECTORY-STREAM must be the directory where the archive got extracted.
;; LAST-ENTRY should be left empty.

(define probe-source-directory
  (lambda (directory-stream last-entry)
    (let ((current-entry (readdir directory-stream)))
      (if (eof-object? current-entry)
	  last-entry
	  (if (or (string=? current-entry "Makefile")
		  (string=? current-entry "Makefile.am")
		  (string=? current-entry "Makefile.in"))
	      "."
	      (begin
		(if (or (string=? current-entry ".")
			(string=? current-entry ".."))
		    (probe-source-directory directory-stream last-entry)
		    (probe-source-directory directory-stream current-entry))))))))

;; Fetch tarball from URI and extract ARCHIVE
(define fetch-and-extract
  (lambda (uri)
    (let* ((archive (list-ref (last-pair (string-split uri #\/)) 0))
	   (archivedir-string (string-append extract-directory "/"
					     archive))
	   (archivedir #f)
	   (extracted-directory #f))
      (statusmsg (_ "Downloading archive file") uri)
      (exec (string-append "wget -P " dist-directory " -nc " uri))
      (if (access? (string-append dist-directory "/" archive) R_OK)
	  (begin (if (access? archivedir-string R_OK)
		     (exec (string-append "rm -rf " archivedir-string)))
		 (mkdir archivedir-string)
		 (tar-extract (string-append dist-directory "/" archive)
			      archivedir-string)
		 (set! archivedir (opendir archivedir-string))
		 (set! extracted-directory (string-append
					    archivedir-string "/"
					    (probe-source-directory archivedir " ")))
		 (closedir archivedir))
	  (errormsg (string-append (_ "Archive file not found in distribution directory: ")
				   archive) 'fatal))
      extracted-directory)))
