;; Scheme frontends for various programs: patch, tar

;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

(define errormsg
  (lambda (message fatal)
    (display (string-append (list-ref (command-line) 0) ": " message))
    (newline)
    (if (eq? fatal 'fatal)
	(quit))))

;; Execute shell COMMAND
(define exec
  (lambda (command)
    (let ((pipe (open-pipe command OPEN_WRITE)))
      (if (eq? (close-pipe pipe) 0)
	  #t
	  #f))))

(define patch
  (lambda (directory patch)
    (display (string-append ">> Applying patch " patch))
    (newline)
    (if (exec (string-append "patch -d " directory
			     " -Np1 " patch ".patch"))
	(begin (display "   Patch successfully applied.")
	       (newline))
	(errormsg (string-append "Failed to apply patch: " patch) 'fatal))))

(define tar-extract
  (lambda (archive-file dest-dir)
    (display (string-append ">> Extracting archive " archive-file))
    (newline)
    (if (exec (string-append "tar -xf " archive-file " -C " dest-dir))
	(begin (display "   Archive file successfully extracted.")
	       (newline))
	(errormsg (string-append "Failed to extract patch: "
				 archive-file) 'fatal))))
