/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <uniexp/Base_opengl.h>


using namespace ux;


Viewport::Viewport(GLsizei _width, GLsizei _height, GLint _x, GLint _y) {
  width = _width; height = _height; x = _x; y = _y;
}

void Viewport::setViewport(GLsizei _width, GLsizei _height, GLint _x, GLint _y) {
  width = _width; height = _height; x = _x; y = _y;
}

GLdouble Viewport::getAspect() const {
  return static_cast<GLdouble>(width) / static_cast<GLdouble>(height);
}

void Viewport::glViewport() const {
  ::glViewport(x, y, width, height);
}



Perspective::Perspective(GLdouble verticalFOV, GLdouble _aspect,
			 GLdouble near, GLdouble far) {
  vFov = verticalFOV; aspect = _aspect; zNear = near; zFar = far;
}

void Perspective::setPerspective(GLdouble verticalFOV, GLdouble _aspect,
				 GLdouble near, GLdouble far) {
  vFov = verticalFOV; aspect = _aspect; zNear = near; zFar = far;
}

void Perspective::setFOV(GLdouble vfov) { vFov = vfov; }

void Perspective::setAspect(GLdouble aspct) { aspect = aspct; }

void Perspective::setAspect(Viewport* frame) { aspect = frame->getAspect(); }

void Perspective::setClipPlanes(GLdouble near, GLdouble far) { zNear = near; zFar = far; }

void Perspective::gluPerspective() const {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  ::gluPerspective(vFov, aspect, zNear, zFar);
};



View::View(GLdouble eyeX, GLdouble eyeY, GLdouble eyeZ,
	   GLdouble atX, GLdouble atY, GLdouble atZ,
	   GLdouble upX, GLdouble upY, GLdouble upZ) {
  eye[0] = eyeX; eye[1] = eyeY; eye[2] = eyeZ;
   at[0] =  atX;  at[1] =  atY;  at[2] =  atZ;
   up[0] =  upX;  up[1] =  upY;  up[2] =  upZ;
}

void View::setView(GLdouble* _eye, GLdouble* _at, GLdouble* _up) {
  if (_eye) {
    eye[0] = _eye[0]; eye[1] = _eye[1]; eye[2] = _eye[2];
  }
  if (_at) {
    at[0] =  _at[0];  at[1] =  _at[1];  at[2] =  _at[2];
  }
  if (_up) {
    up[0] =  _up[0];  up[1] =  _up[1];  up[2] =  _up[2];
  }
}

void View::setEye(GLdouble eyeX, GLdouble eyeY, GLdouble eyeZ) {
  eye[0] = eyeX; eye[1] = eyeY; eye[2] = eyeZ;
}

void View::setAt(GLdouble atX, GLdouble atY, GLdouble atZ) {
  at[0] = atX; at[1] = atY; at[2] = atZ;
}

void View::setUp(GLdouble upX, GLdouble upY, GLdouble upZ) {
  up[0] = upX; up[1] = upY; up[2] = upZ;
}

void View::direction(GLdouble* dir) {
  at[0] = eye[0] + dir[0]; at[1] = eye[1] + dir[1]; at[2] = eye[2] + dir[2];
}

void View::gluLookAt() const {
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  ::gluLookAt(eye[0], eye[1], eye[2], at[0], at[1], at[2], up[0], up[1], up[2]);
}


void Camera::setViewport(GLsizei _width, GLsizei _height, GLint _x, GLint _y) {
  width = _width; height = _height; x = _x; y = _y;
  aspect = this->getAspect();
}




Spinner::Spinner(const Coord3& spinByAxis, const Coord3& initialAngles) {
  angles = initialAngles;
  spins = spinByAxis;
  axisBits = 0;
}

Spinner::~Spinner() { }

void Spinner::doSpin(unsigned int _axisBits) {
  axisBits = _axisBits;
}

void Spinner::setAngles(Coord aX, Coord aY, Coord aZ) { angles.set(aX, aY, aZ); }
void Spinner::setSpinX(Coord ang) { spins.setX(ang); }
void Spinner::setSpinY(Coord ang) { spins.setY(ang); }
void Spinner::setSpinZ(Coord ang) { spins.setZ(ang); }

void Spinner::glRotate() {
  Coord ang = angles.X();
  ::glRotate(ang, 1.0, 0.0, 0.0);
  if (axisBits & SPIN_X) {
    angles.setX( (ang += spins.X()) );
    if (ang > 360.0) angles.setX(0.0);
    else if (ang < 0.0) angles.setX(360.0);
  }
  ang = angles.Y();
  ::glRotate(ang, 0.0, 1.0, 0.0);
  if (axisBits & SPIN_Y) {
    angles.setY( (ang += spins.Y()) );
    if (ang > 360.0) angles.setY(0.0);
    else if (ang < 0.0) angles.setY(360.0);
  }
  ang = angles.Z();
  ::glRotate(ang, 0.0, 0.0, 1.0);
  if (axisBits & SPIN_Z) {
    angles.setZ( (ang += spins.Z()) );
    if (ang > 360.0) angles.setZ(0.0);
    else if (ang < 0.0) angles.setZ(360.0);
  }
}



RealTime::RealTime(float framesPerSecond) {
  now = SDL_GetTicks();
  msPerFrame = static_cast<unsigned long int>(1000.0 / framesPerSecond);
  nextTime = now + msPerFrame;
}

void RealTime::setFPS (float framesPerSecond) {
  msPerFrame = static_cast<unsigned long int>(1000.0 / framesPerSecond);
  now = SDL_GetTicks();
  nextTime = now + msPerFrame;
}

void RealTime::keepFPS() {
  now = SDL_GetTicks();
  if (nextTime > now)
    SDL_Delay(nextTime - now);
  nextTime += msPerFrame;
}
