/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <iostream>

#include <uniexp/Numbers.h>


using std::istream;
using std::ostream;

using namespace ux;


baseRandom::baseRandom(unsigned int seed, size_t randVectorLen) {
  _seed = seed;
  _randVectorLen = randVectorLen;
  _randVector = new char[_randVectorLen];
  reinit();
}

baseRandom::~baseRandom() {
  delete[] _randVector;
}

void baseRandom::reinit(unsigned int seed) {
  unsigned int thisSeed = seed ? seed : _seed ? _seed : time(0);
  initstate(thisSeed, _randVector, _randVectorLen);
}


URandom::URandom(unsigned int seed, size_t randDomain, size_t randVectorLen)
  : baseRandom(seed, randVectorLen) {
  _randDomain = randDomain;
}

size_t URandom::domain () const {
  return _randDomain;
}

unsigned int URandom::operator()() const {
  return random() % _randDomain;
}


Random::Random (double low, double high,
		unsigned int seed, size_t randVectorLen)
  : baseRandom(seed, randVectorLen) {
  setRange(low, high);
}

const Random& Random::setRange(double low, double high) {
  _low = low;
  _high = high;
  _delta = (_high - _low) / static_cast<double>(RAND_MAX);
  return *this;
}

double Random::min() const { return _low; }

double Random::max() const { return _high; }

double Random::operator()() const {
  return _low + random() * _delta;
}

istream& ux::operator>>(istream& is, Random& rn) {
  return is;
}

ostream& ux::operator<<(ostream& os, const Random& rn) {
  return os<<"<random high=\""<<rn._high<<"\" low=\""<<rn._low<<"\" delta=\""<<rn._delta<<" />";
}
