/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <uniexp/Attrs.h>
#include <uniexp/UniEXP.h>


using namespace ux;


UniEXP::UniEXP(Art_0* root, const std::string& name)
  : Attrs("uniexpAttrs", name)
{
  rootNode = root;
}

UniEXP::~UniEXP () { }



Art_0* UniEXP::setRootNode(Art_0* art) {
  Art_0* old = rootNode;
  rootNode = art;
  return old;
}

Art_0* UniEXP::getRootNode() {
  return rootNode;
}

const Art_0* UniEXP::getRootNode() const {
  return rootNode;
}
