/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <sys/time.h>
#include <unistd.h>
#include <iostream>
#include <fstream>

#include <uniexp/Auxl.h>
#include <uniexp/Prog.h>

using namespace std;
using namespace ux;

void Getopts::extract(int* argc, char*** argv) {
  char key;
  char opt[3];
  opt[1] = ':';
  opt[2] = 0;
  optarg = 0;
  while( (key = getopt(*argc, *argv, _op.c_str())) != '?' && key != -1) {
    opt[0] = key;
    if(_op.find(opt) != _op.npos) {
     insert(_pmm_cs(key, optarg? optarg: ""));
    }
    else {
      insert(_pmm_cs(key, "1"));
    }
    optarg = 0;
  }
  if(key == '?')
    throw Excc(_str("Parâmetro inválido: ") + key);
  if(key == -1) {
    for(int j=optind; j<*argc; j++)
      insert(_pmm_cs('#', (*argv)[j]));
  }
}

string Getopts::op(char key) const {
  _CImm_cs I = equal_range(key);
  if (I.first != I.second) {
    _cimm_cs i = I.first;
    return (*i).second;
  }
  else {
    return string("");
  }
}

string Getopts::options(const string& sep) const {
  string opts;
  if (! size())
    return opts;
  _cimm_cs i = begin();
  opts += _str((*i).first) + "=" + (*i).second;
  for(++i; i!= end(); i++)
    opts += sep + _str((*i).first) + "=" + (*i).second;
  return opts;
}

double now() {
  struct timeval tval;
  gettimeofday(&tval, 0);
  char t[50];
  sprintf(t, "%li.%06li", tval.tv_sec, tval.tv_usec);
  string tx(t);
  tx=tx.substr(tx.find('.') - 5);
  return _str_dbl(tx);
}

double now(const string& label) {
  double tx = now();
  cerr<<">>-->> "<<label<<": "<<tx<<endl;
  return tx;
}

double now(const string& label, double t_ref) {
  double tx = now();
  cerr<<">>-->> "<<label<<": "<<(tx - t_ref)<<endl;
  return tx;
}

