/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif
#include <EXTERN.h>
#include <perl.h>
#ifdef __cplusplus
}
#endif


#include <uniexp/Perl.h>


static PerlInterpreter *my_perl = NULL;


int perl_ini(int* a, char*** b, char*** c) {
  char perlsist[BUFF_4]; strcpy(perlsist,"package Embed::Perlsist;\n\n");
  strcat(perlsist,"use strict;\nour %Cache;\nuse Symbol qw(delete_package);\n\n");
  strcat(perlsist,"sub valid_package_name {\n    my($string) = @_;\n");
  strcat(perlsist,"  $string =~ s/([^A-Za-z0-9\\/])/sprintf(\"_%2x\",unpack(\"C\",$1))/eg;\n");
  strcat(perlsist,"  # second pass only for words starting with a digit\n");
  strcat(perlsist,"  $string =~ s|/(\\d)|sprintf(\"/_%2x\",unpack(\"C\",$1))|eg;\n");
  strcat(perlsist,"  # Dress it up as a real package name\n");
  strcat(perlsist,"  $string =~ s|/|::|g;\n    return \"Embed\" . $string;\n}\n\n");
  strcat(perlsist,"sub eval_txt {\n  return if !$_[0];\n");
  strcat(perlsist,"  my $perl=\"$_[0]\"; eval qq{ $perl; }; die $@ if $@;\n}\n\n");
  strcat(perlsist,"sub eval_sub {\n  return if !$_[0];\n");
  strcat(perlsist,"  my($pack,$sub,$perl);\n");
  strcat(perlsist,"  if($_[0]=~/(?:package\\s+([\\w\\:]+)\\s*;)(.*)$/s)\n");
  strcat(perlsist,"    { $pack=$1; $perl=$2; } else { $perl=$_[0]; }\n");
  strcat(perlsist,"  if($perl=~/(?<![[:graph:]])(?:sub\\s+([\\w\\:]+))(.+)/s)\n");
  strcat(perlsist,"    { $sub=\"$1\"; $perl=$2; $sub=\"${pack}::$sub\" if $pack; }\n");
  strcat(perlsist,"  else { die \"subrotina indefinida\"; }\n");
  strcat(perlsist,"  eval qq{ sub $sub $perl; }; die $@ if $@;\n}\n\n");
  strcat(perlsist,"sub eval_arq {\n  die \"arquivo \\\"$_[0]\\\": $!\" if ! -r $_[0];\n");
  strcat(perlsist,"  my($arq, $cache) = @_;\n");
  strcat(perlsist,"  my $pack = valid_package_name($arq);\n");
  strcat(perlsist,"  my $mtime = -M $arq;\n");
  strcat(perlsist,"  if(defined $Cache{$pack}{mtime} && $Cache{$pack}{mtime} <= $mtime)\n");
  strcat(perlsist,"  { # we have compiled this subroutine already,\n");
  strcat(perlsist,"    # it has not been updated on disk, nothing left to do\n");
  strcat(perlsist,"    # print STDERR \"already compiled $pack->handler\\n\";\n");
  strcat(perlsist,"  } else {\n");
  strcat(perlsist,"    local *FH; open FH, $arq or die \"arquivo \\\"$arq\\\": $!\";\n");
  strcat(perlsist,"    local($/)=undef; my $sub=<FH>; close FH;\n");
  strcat(perlsist,"    #wrap the code into a subroutine inside our unique package\n");
  strcat(perlsist,"    my $eval = qq{package $pack; sub handler { $sub; }};\n");
  strcat(perlsist,"    { # hide our variables within this block\n");
  strcat(perlsist,"      my($arq,$mtime,$pack,$sub);\n     eval $eval;\n");
  strcat(perlsist,"    }\n       die $@ if $@;\n");
  strcat(perlsist,"    #cache it unless we are cleaning out each time\n");
  strcat(perlsist,"    $Cache{$pack}{mtime} = $mtime if $cache;\n");
  strcat(perlsist,"  }\n");
  strcat(perlsist,"  eval {$pack->handler;};\n");
  strcat(perlsist,"  die $@ if $@;\n");
  strcat(perlsist,"  delete_package($pack) unless $cache;\n");
  strcat(perlsist,"  #take a look if you want\n");
  strcat(perlsist,"  #print Devel::Symdump->rnew($pack)->as_string, $/;\n");
  strcat(perlsist,"}\n\n1;\n\n__END__\n\n");
  char *interpr[] = { "", "-e", perlsist }; int exitstatus=0;
  PERL_SYS_INIT3(&argc,argv,env);
  if((my_perl=perl_alloc())==0) { fprintf(stderr,"no memory!"); exit(1); }
  perl_construct(my_perl);
  exitstatus=perl_parse(my_perl,0,2,interpr,0);
  PL_exit_flags|=PERL_EXIT_DESTRUCT_END;
  if(!exitstatus) exitstatus=perl_run(my_perl);
  return exitstatus;
}
void perl_fim() {
  PL_perl_destruct_level = 0;
  perl_destruct(my_perl);
  perl_free(my_perl);
  PERL_SYS_TERM();
}


void perl_arq(const char* arq, bool cache) {
  char del[2]; del[0]=cache? '1': '0'; del[1]=0;
  char *args[]={ const_cast<char*>(arq), del, 0 }; STRLEN n_a;
  call_argv("Embed::Perlsist::eval_arq",G_DISCARD|G_EVAL,args);
  if(SvTRUE(ERRSV)) fprintf(stderr, "ERRO em eval: %s\n", SvPV(ERRSV,n_a)); // check $@
}
void perl_sub(const char* p) {
  char* args[]={ const_cast<char*>(p), 0 }; STRLEN n_a;
  call_argv("Embed::Perlsist::eval_sub",G_DISCARD|G_EVAL,args);
  if(SvTRUE(ERRSV)) fprintf(stderr, "ERRO em eval: %s\n", SvPV(ERRSV,n_a)); // check $@
}
void perl_exe(const char* p) {
  char* args[]={ const_cast<char*>(p), 0 }; STRLEN n_a;
  call_argv("Embed::Perlsist::eval_txt",G_DISCARD|G_EVAL,args);
  if(SvTRUE(ERRSV)) fprintf(stderr, "ERRO em eval: %s\n", SvPV(ERRSV,n_a)); // check $@
}
int          perl_int (const char* p) { return SvIV(eval_pv(p,TRUE)); }
unsigned int perl_uint(const char* p) { return SvUV(eval_pv(p,TRUE)); }
double       perl_dbl (const char* p) { return SvNV(eval_pv(p,TRUE)); }
const char*  perl_str (const char* p) { STRLEN n_a; return SvPV(eval_pv(p,TRUE), n_a); }


void perl_arq_tty(bool cache) {
  printf("Nomes de arquivos Perl, C-d para encerrar:\n");
  char del[2]; del[0]=cache? '1': '0'; del[1]=0;
  char *args[] = { "",del,0 };
  char arqv[BUFF_1];  STRLEN n_a;
  while(printf("Arquivo: ") && ( fgets(arqv,BUFF_1,stdin)||(printf("\n")&&false) )) {
    args[0] = arqv;   arqv[strlen(arqv)-1] = '\0';   /* strip \n */
    call_argv("Embed::Perlsist::eval_arq",G_DISCARD|G_EVAL,args);
    if(SvTRUE(ERRSV)) fprintf(stderr, "ERRO em eval: %s\n", SvPV(ERRSV,n_a)); // check $@
} }
void perl_sub_tty() {
  char pe[BUFF_4], li[BUFF_1]; pe[0]=0;
  char *args[] = { pe, 0 }; STRLEN n_a;
  printf("\nSubrotina (máx 4k, 1k/linha), C-d para encerrar:\n\n");
  while(fgets(li,BUFF_1,stdin)) strcat(pe,li);        printf("\n");
  args[0]=pe; call_argv("Embed::Perlsist::eval_sub",G_DISCARD|G_EVAL,args);
  if(SvTRUE(ERRSV)) fprintf(stderr, "ERRO em eval: %s\n", SvPV(ERRSV,n_a)); // check $@
}
void perl_exe_tty() {
  printf("\nScript (máx.4k, 1k/linha), C-d para encerrar:\n\n");
  char pe[BUFF_4], li[BUFF_1]; pe[0]=0;
  char *args[] = { pe, 0 }; STRLEN n_a;
  while(fgets(li,BUFF_4,stdin)) strcat(pe,li);     printf("\n");
  args[0]=pe; call_argv("Embed::Perlsist::eval_txt",G_DISCARD|G_EVAL,args);
  if(SvTRUE(ERRSV)) fprintf(stderr, "ERRO em eval: %s\n", SvPV(ERRSV,n_a)); // check $@
}


