/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <iostream>
#include <sstream>
#include <uniexp/Auxl.h>


namespace ux {

char _str_chr (const std::string& s) {
  std::istringstream i(s);
  char x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_chr( " +s+" )");
  return x;
}

unsigned char _str_uchr (const std::string& s) {
  std::istringstream i(s);
  unsigned char x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_uchr( "+s+" )");
  return x;
}

short _str_shr (const std::string& s) {
  std::istringstream i(s);
  short x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_shr( " +s+" )");
  return x;
}

unsigned short _str_ushr (const std::string& s) {
  std::istringstream i(s);
  unsigned short x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_ushr( "+s+" )");
  return x;
}

int _str_int (const std::string& s) {
  std::istringstream i(s);
  int x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_int( " +s+" )");
  return x;
}

unsigned int _str_uint (const std::string& s) {
  std::istringstream i(s);
  unsigned int x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_uint( "+s+" )");
  return x;
}

long _str_lng (const std::string& s) {
  std::istringstream i(s);
  long x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_lng( " +s+" )");
  return x;
}

unsigned long _str_ulng (const std::string& s) {
  std::istringstream i(s);
  unsigned long x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_ulng( "+s+" )");
  return x;
}

long long _str_llg (const std::string& s) {
  std::istringstream i(s);
  long long x;
  if ( !(i>>x))
    throw Excc("ERRO de conversão: _str_llg( " +s+" )");
  return x;
}

unsigned long long _str_ullg (const std::string& s) {
  std::istringstream i(s);
  unsigned long long x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_ullg( "+s+" )");
  return x;
}

float _str_flt (const std::string& s) {
  std::string m(s);
  size_t r;
  if ((r=m.rfind(',')) != m.npos) {
    m[r]='.';
    while (--r >= 0)
      if (m[r] == '.')
	m.erase(r, 1);
  }
  std::istringstream i(m);
  float x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_flt( " +s+" )");
  return x;
}

double _str_dbl (const std::string& s) {
  std::string m(s);
  size_t r;
  if ((r=m.rfind(',')) != m.npos) {
    m[r]='.';
    while (--r >= 0)
      if (m[r] == '.')
	m.erase(r, 1);
  }
  std::istringstream i(m);
  double x;
  if (! (i>>x))
    throw Excc("ERRO de conversão: _str_dbl( " +s+" )");
  return x;
}


std::string _str (const char& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( char )");
  return o.str();
}

std::string _str (const unsigned char& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( unsigned char )");
  return o.str();
}

std::string _str (const short& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( short )");
  return o.str();
}

std::string _str (const unsigned short& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( unsigned short )");
  return o.str();
}

std::string _str (const int& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( int )");
  return o.str();
}

std::string _str (const unsigned int& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( unsigned int )");
  return o.str();
}

std::string _str (const long& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( long )");
  return o.str();
}

std::string _str (const unsigned long& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( unsigned long )");
  return o.str();
}

std::string _str (const long long& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( long long )");
  return o.str();
}

std::string _str (const unsigned long long& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( unsigned long long )");
  return o.str();
}

std::string _str(const float& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( float )");
  return o.str();
}

std::string _str(const double& x) {
  std::ostringstream o;
  if (! (o<<x))
    throw Excc("ERRO de conversão: _str( double )");
  return o.str();
}

std::string _str(const char* t) {
  return std::string(t);
}




std::istream& operator>>(std::istream& is, TP& tp) {
  return is>>tp._tp;
}

std::ostream& operator<<(std::ostream& os, const TP& tp) {
  return os<<tp._tp;
}

TP::~TP()
{ }



std::istream& operator>>(std::istream& is, ID& id) {
  return is>>id._id;
}

std::ostream& operator<<(std::ostream& os, const ID& id) {
  return os<<id._id;
}

ID::~ID()
{ }



std::istream& operator>>(std::istream& is, TPID& tpid) {
  char ig;
  return is>>static_cast<TP&>(tpid)>>ig>>static_cast<ID&>(tpid);
}

std::ostream& operator<<(std::ostream& os, const TPID& tpid) {
  return os<<static_cast<const TP&>(tpid)<<':'<<static_cast<const ID&>(tpid);
}

TPID::~TPID()
{ }


} /* namespace ux */
