/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <uniexp/Attrs.h>


using std::string;
using std::ostream;
using std::istream;

using std::cout;
using std::endl;

using namespace ux;



Attrs::Attrs(const Attrs& src)
  : TPID(src.tp(), src.id()+".C") {
  /** esta implementação copia de fato */
  for (_cim_sV i=src.begin(); i!=src.end(); i++) {
    insert(std::make_pair<string, Virtual*>(i->first, static_cast<Virtual*>(i->second->clone())));
  }
  // esta seria a implementação ideal mas não copia se não implementar...
  // insert(begin(), src.begin(), src.end());
}

Attrs::Attrs(const std::string& _tp, const std::string& _id)
  : TPID(_tp, _id) {
}

Attrs::Attrs(const _m_sV& m, const std::string& _tp, const std::string& _id)
  : _m_sV(m), TPID(_tp, _id) {
}

Attrs::~Attrs() {
  for (_im_sV i=begin(); i!=end(); i++) {
    Virtual* ptr = i->second;
    if (ptr) {
      delete ptr;
    }
    erase(i);
  }
}

const Attrs& Attrs::operator=(const Attrs& attrs) {
  if (&attrs != this) {
    static_cast<_m_sV*>(this)->operator=(attrs);
    tpid(attrs.tp(), attrs.id());
  }
  return *this;
}

istream& ux::operator>>(istream& is, Attrs& a) {
  return is;
} 

ostream& ux::operator<<(ostream& os, const Attrs& a) {
  os<<"<attrs tp=\""<<a.tp()<<"\" id=\""<<a.id()<<"\">";
  for (_cim_sV i=a.begin();i!=a.end();i++) {
    os<<"<elem key=\""<<i->first<<"\">";
    (i->second->output(os))<<"</elem>";
  }
  return os<<"</attrs>";
}

