/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <uniexp/Art_va.h>


using std::string;
using std::ostream;
using std::istream;
using std::cout;
using std::endl;


using namespace ux;


Art_VA::Art_VA(const Art_VA& src)
  : Art_0(src) {
  for (_civ_AA i=src.begin(); i!=src.end(); i++) {
    AllocC<Art_0> alloc(static_cast<Art_VA*>(i->ptr()->clone()));
    push_back(alloc);
  }
}

Art_VA::Art_VA(AllocC<Attrs>* alloc)
  : Art_0(alloc) {
  tp("Art_VA");
}

Art_VA::Art_VA(const Attrs& attrs)
  : Art_0(attrs) {
  tp("Art_VA");
}

const Art_VA& Art_VA::operator=(const Art_VA& src) {
  if(this != &src) {
    static_cast<Art_0*>(this)->operator=(src);
    clear();
    for (_civ_AA i=src.begin(); i!=src.end(); i++) {
      AllocC<Art_0> alloc(static_cast<Art_VA*>(i->ptr()->clone()));
      push_back(alloc);
    }
    //insert(begin(), art.begin(), art.end(), functor);
  }
  return *this;
}

Art_VA::~Art_VA() {
  for (_iv_AA i=begin(); i!=end(); i++) {
    desh(i->ptr());
  }
}

void Art_VA::clear() {
  for (_iv_AA i=begin(); i!=end(); i++) {
    desh(i->ptr());
  }
}

Art_0* Art_VA::art(size_t pos) {
  size_t sz = size();
  if (pos>=0 && pos<sz)
    return operator[](pos).ptr();
  if (pos<0 && sz+pos>=0)
    return operator[](sz+pos).ptr();
  return 0;
}

Art_0* Art_VA::art(const string& artName) {
  for (_iv_AA i=begin(); i!=end(); i++)
    if ((*i).ptr()->id() == artName)
      return (*i).ptr();
  return 0;
}

Art_0* Art_VA::sub(const string& artName) {
  if(id() == artName)
    return this;
  Art_0* art;
  for (_iv_AA i=begin(); i!=end(); i++) {
    if ( (art = (*i).ptr()->sub(artName)) )
      return art;
  }
  return 0;
}

Art_0* Art_VA::art_e(const string& attrsName) {
  for (_iv_AA i=begin(); i!=end(); i++)
    if ((*i).ptr()->getAttrs()->id() == attrsName)
      return (*i).ptr();
  return 0;
}

Art_0* Art_VA::sub_e(const string& attrsName) {
  if(getAttrs()->id() == attrsName)
    return this;
  Art_0* art;
  for (_iv_AA i=begin();i!=end(); i++) {
    if ( (art = (*i).ptr()->sub_e(attrsName)) )
      return art;
  }
  return 0;
}

bool Art_VA::empty() const {
  return static_cast<const _v_AA*>(this)->empty();
}

size_t Art_VA::size() const {
  return _v_AA::size();
}

void Art_VA::ad_ini(Art_0* art) {
  insert(begin(), *art);
  adot(front().ptr());
}

void Art_VA::ad_fim(Art_0* art) {
  Art_VA* artVA = dynamic_cast<Art_VA*>(art);
  if (artVA) {
    push_back(AllocC<Art_0>(*artVA));
    adot(back().ptr());
    AllocC<Art_0> alloc(back());
  }
}

bool Art_VA::set_pos(Art_0* art, int pos) {
  if (! art) {
    return false;
  }
  size_t sz = size();
  if(pos>=0 && pos<sz) {
    (operator[](pos)) = AllocC<Art_0>(*art);
    adot(art);
    return true;
  }
  if(pos<0 && sz+pos>=0) {
    (operator[](sz+pos)) = AllocC<Art_0>(*art);
    adot(art);
    return true;
  }
  return false;
}

bool Art_VA::set_ref(Art_0* art, Art_0* ref) {
  _iv_AA i = find(begin(), end(), ref);
  if (i != end()) {
    *i = AllocC<Art_0>(*art);
    adot(art);
    return true;
  }
  return false;
}

bool Art_VA::ad_pos(Art_0* art, int pos) {
  int count = 0;
  for (_iv_AA i=begin(); i!=end(); i++) {
    if (count == pos) {
      insert(i, AllocC<Art_0>(*art));
    }
    count++;
  }
}

bool Art_VA::ad_pre(Art_0* art, Art_0* ref) {
  _iv_AA i = find(begin(), end(), ref);
  if (i != end()) {
    insert(i, AllocC<Art_0>(*art));
    adot(art);
    return true;
  }
  return false;
}

bool Art_VA::ad_post(Art_0* art, Art_0* ref) {
  _iv_AA i = find(begin(), end(), ref);
  if (i != end()) {
    insert(++i, AllocC<Art_0>(*art));
    adot(art);
    return true;
  }
  return false;
}

void Art_VA::rm_pri() {
  if (size() > 0) {
    desh(begin()->ptr());
    erase(begin());
  }
}

void Art_VA::rm_ult() {
  if(size() > 0) {
    _iv_AA i = end();
    desh((--i)->ptr());
    erase(i);
  }
}

bool Art_VA::rm_pos(int pos) {
  size_t sz = size();
  if (pos>=0 && pos<sz) {
    _iv_AA i = begin();
    for (int j=0; j<pos; j++)
      desh((++i)->ptr());
    erase(i);
    return true;
  }
  if (pos<0 && sz+pos>=0) {
    _iv_AA i = begin();
    for (int j=0; j<sz+pos; j++)
      desh((++i)->ptr());
    erase(i);
    return true;
  }
  return false;
}

bool Art_VA::rm_art(Art_0* art) {
  _iv_AA i = find(begin(), end(), art);
  if (i != end()) {
    erase(i);
    return true;
  }
  return false;
}

void Art_VA::xx(_fn_varr* fn, Attrs* attrs) {
  fn->operator()(this, attrs);
  for (_iv_AA i=begin(); i!=end(); i++) {
    Art_VA* artVA = dynamic_cast<Art_VA*>(i->ptr());
    if (artVA) {
      artVA->xx(fn, attrs);
    }
  }
}

void Art_VA::zx(_fn_varr* fn, Attrs* attrs) {
  for(_riv_AA i=rbegin(); i!=rend(); i++)
    i->ptr()->zx(fn, attrs);
  fn->operator()(this, attrs);
}

void Art_VA::pp(_fn_varr* preFn, _fn_varr* postFn, Attrs* attrs) {
  preFn->operator()(this, attrs);
  for(_iv_AA i=begin(); i!=end(); i++) {
    i->ptr()->pp(preFn, postFn, attrs);
  }
  postFn->operator()(this, attrs);
}

void Art_VA::cc(_fn_varr* preChildFn, _fn_varr* postChildFn, Attrs* attrs) {
  for(_iv_AA i=begin(); i!=end(); i++) {
    preChildFn->operator()(this, attrs);
    i->ptr()->cc(preChildFn, postChildFn, attrs);
    postChildFn->operator()(this, attrs);
  }
}

void Art_VA::ppcc(_fn_varr* preFn, _fn_varr* postFn, _fn_varr* preChildFn, _fn_varr* postChildFn, Attrs* attrs) {
  preFn->operator()(this, attrs);
  for(_iv_AA i=begin(); i!=end(); i++) {
    preChildFn->operator()(this, attrs);
    (*i).ptr()->ppcc(preFn, postFn, preChildFn, postChildFn, attrs);
    postChildFn->operator()(this, attrs);
  }
  postFn->operator()(this, attrs);
}


istream& ux::operator>>(istream& is, Art_VA& av) { return is; }

ostream& ux::operator<<(ostream& os, const Art_VA& art) {
  os<<"<art tp=\""<<art.tp()<<"\" id=\""<<art.id()<<"\" base=\"";
  if (art._base) {
    os<<art.path()<<"\">";
  } else {
    os<<"0\">";
  }
  os<<*(art._attrs.ptr());
  for (_civ_AA i=art.begin(); i!=art.end(); i++) {
    const Art_VA* artVA = dynamic_cast<const Art_VA*>(i->ptr());
    if (artVA) {
      os<<"<elem>"<<*artVA<<"</elem>";
    } else {
      os<<"NULL_DYNAMIC_CAST";
    }
  }
  return os<<"</art>";
}
