/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <iostream>

#include <uniexp/Art_0.h>


using std::string;
using std::ostream;
using std::istream;

using std::cin;
using std::cout;
using std::cerr;
using std::endl;

using namespace ux;


_fn_varr::_fn_varr()
  : _count(0), TPID("_fn_varr", "noid") {
  //cout<<"constructor "<<tp()<<'['<<id()<<']'<<endl;
}

_fn_varr::_fn_varr(const _fn_varr& src)
  : _count(0), TPID(src.tp(), src.id()+".C") {
  //cout<<"constructor 1"<<tp()<<'['<<id()<<']'<<endl;
}

_fn_varr::_fn_varr(const std::string& _tp, const std::string& _id)
  : _count(0), TPID(_tp, _id) {
  //cout<<"constructor 2"<<tp()<<'['<<id()<<']'<<endl;
}

_fn_varr::~_fn_varr() {
  //cout<<"destructor "<<tp()<<'['<<id()<<']'<<endl;
}

void _fn_varr::init() {
  _count = 0;
}

void _fn_varr::operator() (Art_0* art, Attrs* attrs) {
  //cout<<"ITER _fn_varr::operator()(Art_0*, Attrs* attrs) deep="<<endl;
}


istream& ux::operator>>(istream& is, _fn_varr& fn) { return is; }

ostream& ux::operator<<(ostream& os, const _fn_varr& fn) {
  return os<<"<_fn_varr tp=\""<<fn.tp()<<"\" id=\""<<fn.id()<<"\">";
}




Art_0::Art_0()
  : TPID("Art_0", "noid"), _base(0), _attrs(AllocC<Attrs>(Attrs())) {
  //cout<<"constructor "<<tp()<<'['<<id()<<']'<<endl;
}

Art_0::Art_0(const std::string& _tp, const std::string& _id)
  : TPID(_tp, _id), _base(0), _attrs(AllocC<Attrs>(Attrs())) {
  //cout<<"constructor "<<tp()<<'['<<id()<<']'<<endl;
}

Art_0::Art_0(const Art_0& src)
  : TPID(src.tp(), src.id()+".C"), _base(src._base), _attrs(src._attrs) {
  //cout<<"constructor "<<tp()<<'['<<id()<<']'<<endl;
}

Art_0::Art_0(const Attrs& attrs)
  : TPID("Art_0", attrs.id()), _attrs(attrs) {
  //cout<<"Art_0::Art_0( const Attrs& ) com "<<attrs<<endl;
}

Art_0::Art_0(AllocC<Attrs>* alloc)
  : TPID("Art_0", alloc->ptr()->id()), _attrs(alloc) {
  //cout<<"Art_0::Art_0( const Alloc<Attrs>* ) com "<<*alloc<<endl;
}

Art_0::~Art_0() {
  //cout<<"destructor "<<tp()<<'['<<id()<<']'<<endl;
}

const Art_0& Art_0::operator=(const Art_0& art) {
  if (this != &art) {
    tp(art.tp());
    _attrs = art._attrs;
  }
  return *this;
}

const Art_0* Art_0::base() const { return _base; }

const Art_0* Art_0::root() const { return _base ? _base->root() : 0; }

Art_0* Art_0::adot(Art_0* art) {
  art->_base = this;
  return art;
}

void Art_0::desh(Art_0* art) {
  if (art->_base == this) {
    delete art;
    art = 0;
  }
}

Art_0* Art_0::sub_c(const string& path) {
  int debug=0;
  if (debug)
    cerr<<"path=["<<path<<"]"<<endl;
  if (path == "/")
    return const_cast<Art_0*>(root());
  if (path == ".." || path == "../")
    return const_cast<Art_0*>(base());
  if (path == "." || path == "./" || path == id())
    return this;
  size_t pos;
  if ( (pos = path.find('/')) == path.npos )
    return this->art(path);
  const_cast<string&>(path) = path.substr(pos + 1);
  if (pos == 0)
    return const_cast<Art_0*>(root()->sub_c(path));
  string subPath = path.substr(0, pos);
  if (debug)
    cerr<<"subPath=["<<subPath<<"], path=["<<path<<"]"<<endl;
  Art_0* art;
  if (subPath == "..")
    art = const_cast<Art_0*>(base());
  else
    art = this->art(subPath);
  if (art)
    return art->sub_c(path);
  return 0;
}

const Art_0* Art_0::sub_c(const string& path) const {
  return const_cast<const Art_0*>(const_cast<Art_0*>(this)->sub_c(path));
}

int Art_0::prof() const {
  return (_base) ? 1+_base->prof() : 1;
}

int Art_0::prof(Art_0* ref) const {
  return (_base) ? (_base == ref) ? 1 : 1 + _base->prof(ref) : 1;
}

string Art_0::path() const {
  string out = id();
  const Art_0* ba = this;
  while ((ba = ba->_base)) {
    out = ba->id() + "/" + out;
  }
  return out;
}

istream& ux::operator>>(istream& is, Art_0& art) { return is; }

ostream& ux::operator<<(ostream& os, const Art_0& art) {
  os<<"<art tp=\""<<art.tp()<<"\" id=\""<<art.path()<<"\">";
  //ArvTex::camh(os, artVA)<<"\n";
  for (size_t i=0; i<art.size(); i++)
    os<<"<elem>"<<*(art.art(i))<<"</elem>";
  return os<<"</art>";
}

